/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.rules;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.objectvalidation.ObjectCloner;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.Rule;
import org.unitils.reflectionassert.ReflectionAssert;
import org.unitils.reflectionassert.ReflectionComparatorMode;
import org.unitils.util.ReflectionUtils;

public class NonMutatingToStringRule
implements Rule {
    private static final Log LOGGER = LogFactory.getLog(NonMutatingToStringRule.class);
    private ObjectCreator objectCreator;
    private ObjectCloner objectCloner;

    public NonMutatingToStringRule(ObjectCreator randomFactory, ObjectCloner objectCloner) {
        this.objectCreator = randomFactory;
        this.objectCloner = objectCloner;
    }

    @Override
    public void validate(Class<?> classToValidate) {
        Method method = ReflectionUtils.getMethod(classToValidate, (String)"toString", (boolean)false, (Class[])new Class[0]);
        if (method != null) {
            Object value = this.objectCreator.createRandomObject(classToValidate);
            Object clone = this.objectCloner.deepClone(value);
            String clonedValueToString = value.toString();
            for (int i = 0; i < 5; ++i) {
                ReflectionAssert.assertReflectionEquals((String)("The toString gives a different output after " + i + " calls"), (Object)clonedValueToString, (Object)value.toString(), (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
                ReflectionAssert.assertReflectionEquals((String)("The content of the object changes when the to string is called " + i + " times"), (Object)clone, (Object)value, (ReflectionComparatorMode[])new ReflectionComparatorMode[0]);
            }
        } else {
            LOGGER.debug((Object)"toString() not found");
        }
    }
}

