/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.rulescollection;

import java.util.ArrayList;
import java.util.List;
import org.unitils.objectvalidation.EqualsHashCodeValidator;
import org.unitils.objectvalidation.ObjectCloner;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.ObjectValidationRulesCollection;
import org.unitils.objectvalidation.Rule;
import org.unitils.objectvalidation.cloner.ObjectClonerFactory;
import org.unitils.objectvalidation.objectcreator.ObjectCreatorFactory;
import org.unitils.objectvalidation.rules.ClassMustBeSerializableRule;
import org.unitils.objectvalidation.rules.EqualsComplientRule;
import org.unitils.objectvalidation.rules.GetterAndSetterComplientRule;
import org.unitils.objectvalidation.rules.HashCodeComplientRule;
import org.unitils.objectvalidation.rules.PublicEmptyConstructorRule;

public class SunBeanRulesWithMocks
implements ObjectValidationRulesCollection {
    private ObjectCreator objectCreator = ObjectCreatorFactory.createMocksObjectCreator();
    private ObjectCloner objectCloner = ObjectClonerFactory.createDefaultCloner();

    @Override
    public List<Rule> getRules() {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        rules.add(new EqualsComplientRule(this.objectCreator, this.objectCloner));
        rules.add(new HashCodeComplientRule(this.objectCreator, this.objectCloner));
        rules.add(new GetterAndSetterComplientRule(this.objectCreator, this.objectCloner));
        rules.add(new ClassMustBeSerializableRule());
        rules.add(new PublicEmptyConstructorRule());
        return rules;
    }

    @Override
    public EqualsHashCodeValidator getEqualsHashCodeValidator() {
        return new EqualsHashCodeValidator(this.objectCreator, this.objectCloner);
    }
}

