package org.unitils.objectvalidation;

import java.util.ArrayList;
import java.util.List;


/**
 * Object collecting the result of every validation that happened on a specific class.
 * 
 * @author Matthieu Mestrez
 * @since Nov 18, 2013
 */
public class ValidationResult {

    private Class<?> validatedClass;
    private List<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
    
    private ValidationResult(Class<?> validatedClass) {
        this.validatedClass = validatedClass;
    }
    
    void addValidationMessage(ValidationMessage validationMessage) {
        validationMessages.add(validationMessage);
    }

    boolean isValid() {
        return validationMessages.isEmpty();
    }
    
    @Override
    public String toString() {
        return validatedClass.getName() + (isValid() ? " is valid." : " is not valid. List of validation messages :\n" + validationMessagesAsString());
    }

    private String validationMessagesAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        
        for (ValidationMessage validationMessage : validationMessages) {
             stringBuilder.append("    " + validationMessage.toString());
             stringBuilder.append("\n");
        }
        
        return stringBuilder.toString();
    }

    public static ValidationResultBuilder buildValidationResultForClass(Class<?> clazz) {
        return new ValidationResultBuilder(clazz);
    }
    
    public static class ValidationResultBuilder {
        
        private ValidationResult validationResult;
        
        public ValidationResultBuilder(Class<?> clazz) {
            validationResult = new ValidationResult(clazz);
        }
        
        public ValidationResultBuilder andMessage(ValidationMessage validationMessage) {
            validationResult.addValidationMessage(validationMessage);
            return this;
        }

        public ValidationResult build() {
            return validationResult;
        }
        
    }
    
    
}
