/*
 * Copyright (c) Smals
 */
package org.unitils.objectvalidation.objectcreator;

import java.util.List;

import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.generator.CompositeGenerator;
import org.unitils.objectvalidation.objectcreator.generator.Generator;


/**
 * A base class for the {@link ObjectCreator}s with basic functions.
 *
 * @author Willemijn Wouters
 *
 * @since 1.1.8
 *
 */
public abstract class BaseObjectCreator implements ObjectCreator {
    private Generator generator;

    public BaseObjectCreator() {
        //default constructor: it does nothing for the moment.
        //I need a generator and a generator needs a ObjectCreator --> stackoverflow.

        //add the generators after creating the ObjectCreator
        this.generator = new CompositeGenerator();
    }

    public BaseObjectCreator(Generator[] generators) {
        CompositeGenerator gen = new CompositeGenerator();
        gen.addGenerators(generators);

        this.generator = gen;
    }

    /**
     * @see org.unitils.objectvalidation.ObjectCreator#getGeneratorOfType(java.lang.Class)
     */
    @Override
    public <T> T getGeneratorOfType(Class<T> generatorType) {
        return getGeneratorOfType(generatorType, ((CompositeGenerator) generator).getGenerators());
    }

    public <T> T getGeneratorOfType(Class<T> generatorType, List<Generator> generators) {
        for (Generator tempGenerator : generators) {
            if (tempGenerator.getClass().isAssignableFrom(generatorType)) {
                return (T) tempGenerator;

            }
            if (tempGenerator instanceof CompositeGenerator) {
                T result = getGeneratorOfType(generatorType, ((CompositeGenerator) tempGenerator).getGenerators());
                if (result != null) {
                    return result;
                }
            }
        }

        return null;
    }


    @Override
    public void addGenerators(Generator... generators) {
        CompositeGenerator gen = (CompositeGenerator) generator;
        gen.addGenerators(generators);
    }

    /**
     * @see org.unitils.objectvalidation.ObjectCreator#getGenerators()
     */
    @Override
    public List<Generator> getGenerators() {
        return ((CompositeGenerator) generator).getGenerators();
    }


    /**
     * @return the generator
     */
    public Generator getGenerator() {
        return generator;
    }
}
