package org.unitils.objectvalidation.objectcreator.generator;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.generator.helper.GeneratorHelper;
import org.unitils.objectvalidation.utils.TreeNode;

/**
 * This generator will take care of interfaces and the classes that have no
 * custom generator.
 *
 * "Cut this object into pieces this is your last resort! "
 *
 * @author Jeroen Horemans
 * @since Feb 20, 2012
 */
public class CollectionGenerator implements Generator {

    private static final int MINIMUM = 1;
    private static final int MAXIMUM = 10;

    private final ObjectCreator objectCreator;

    public CollectionGenerator(ObjectCreator objectCreator) {
        this.objectCreator = objectCreator;
    }

    @SuppressWarnings({
        "unchecked", "rawtypes"
    })
    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses, List<TreeNode> genericSubTypes) throws Exception {
        if (clazz.isInterface()) {

            if (clazz.isAssignableFrom(Map.class)) {
                Map<Object, Object> hashMap = new HashMap<Object, Object>();

                for (int i = 0; i < numberOfObjectsToGenerate(); i++) {

                    Object key = createRandomObject(genericSubTypes.isEmpty() ? Object.class : genericSubTypes.get(0).getValue());
                    Object value = createRandomObject(genericSubTypes.isEmpty() ? Object.class : genericSubTypes.get(1).getValue());

                    hashMap.put(key, value);
                }

                return hashMap;
            }

            if (clazz.isAssignableFrom(List.class)) {
                return createListOf(genericSubTypes.isEmpty() ? new TreeNode(Object.class) : genericSubTypes.get(0));
            }
            if (clazz.isAssignableFrom(Set.class)) {

                if (CollectionUtils.isEmpty(genericSubTypes)) {
                    return new HashSet<Object>(createListOf(new TreeNode(Object.class)));
                }

                return new HashSet(createListOf(genericSubTypes.get(0)));
            }
        }

        if (clazz.isArray()) {
            //TODO: this can be done better. Their is a little difference between the Mocks generator and the normal generator. The normal generator knows which object will be the following object, but the mocks object doesn't know it.
            TreeNode node = null;
            if (genericSubTypes.isEmpty()) {
                node = GeneratorHelper.createTreenode(Object.class);
            } else if (genericSubTypes.get(0).getValue().isArray()) {
                node = GeneratorHelper.createTreenode(genericSubTypes.get(0).getValue().getComponentType());
            } else {
                node = GeneratorHelper.createTreenode(genericSubTypes.get(0).getValue());
            }

            List listOfObjects = createListOf(node);

            Object newInstance = Array.newInstance(node.getValue(), listOfObjects.size());
            for (int i = 0; i < listOfObjects.size(); i++) {

                Array.set(newInstance, i, listOfObjects.get(i));

            }

            return newInstance;
        }

        return null;
    }

    @SuppressWarnings({
        "unchecked", "rawtypes"
    })
    private List createListOf(TreeNode subTypes) throws Exception {
        List list = new ArrayList();

        for (int i = 0; i < numberOfObjectsToGenerate(); i++) {
            TreeNode treenode = GeneratorHelper.createTreenode(subTypes.getType() == null ? subTypes.getValue() : subTypes.getType());
            treenode.setGenericSubtype(Arrays.asList(treenode));
            list.add(objectCreator.createRandomObject(treenode));
        }
        return list;
    }


    @SuppressWarnings("unchecked")
    private <T> T createRandomObject(Class<T> clazz) {
        if (clazz == null) {
            return (T) objectCreator.createRandomObject(Object.class);
        }
        return (T) objectCreator.createRandomObject(clazz);

    }

    private static int numberOfObjectsToGenerate() {
        return MINIMUM + (int) (Math.random() * ((MAXIMUM - MINIMUM) + 1));
    }

}
