package org.unitils.objectvalidation.objectcreator.generator;

import java.util.List;

import org.unitils.mock.core.MockObject;
import org.unitils.objectvalidation.utils.TreeNode;


/**
 * This class generates a mock object of a specific {@link Class} and should be the final option.
 *
 * @author Willemijn Wouters
 *
 * @since 1.1.8
 *
 */
public class MocksGenerator implements Generator {

    /**
     * @see org.unitils.objectvalidation.objectcreator.generator.Generator#generateObject(java.lang.Class, java.util.List, java.util.List, java.util.List)
     */
    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses, List<TreeNode> genericSubTypes) throws Exception {
        return createMockObject(clazz);
    }
    /**
     * This method creates a mock of type clzz.
     * @param clzz : the type that should be mocked.
     * @return {@link Object}
     */
    public Object createMockObject(Class<?> clzz) {
        MockObject<Object> mockObj = new MockObject<Object>(clzz, this);
        mockObj.resetBehavior();
        Object obj = null;
        mockObj.returns(true).equals(obj);
        Object mock = mockObj.getObjectToInject();
        return mock;
    }

}
