package org.unitils.objectvalidation.objectcreator.generator;

import java.lang.reflect.Type;
import java.util.List;

import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.reflect.TypeWrapper;
import org.unitils.objectvalidation.utils.TreeNode;

import sun.reflect.generics.reflectiveObjects.TypeVariableImpl;


/**
 * Generate objects of type {@link TypeVariableImpl}.
 *
 * @author Willemijn Wouters
 *
 * @since 1.1.8
 *
 */
public class TypeVariableImplGenerator implements Generator {

    private ObjectCreator objectCreator;

    /**
     *
     */
    public TypeVariableImplGenerator(ObjectCreator objectCreator) {
        this.objectCreator = objectCreator;
    }
    /**
     * @see org.unitils.objectvalidation.objectcreator.generator.Generator#generateObject(java.lang.Class, java.util.List, java.util.List, java.util.List)
     */
    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses, List<TreeNode> genericSubTypes) throws Exception {
        if (shouldCreateThisObject(clazz, genericSubTypes)) {
            return createObjectOfTypeVariableImpl((TypeVariableImpl<?>) genericSubTypes.get(0).getType());
        }
        return null;
    }

    protected boolean shouldCreateThisObject(Class<?> clazz, List<TreeNode> genericSubTypes) {
        return TypeVariableImpl.class.isAssignableFrom(clazz) &&  !genericSubTypes.isEmpty() && genericSubTypes.get(0).getType() instanceof TypeVariableImpl<?>;
    }

    public Object createObjectOfTypeVariableImpl(TypeVariableImpl<?> type) {
        Type[] bounds = type.getBounds();
        if (bounds.length > 0) {
            Type typeBounds = bounds[0];
            TreeNode treenode = new TreeNode((Class<?>) (new TypeWrapper(typeBounds).isClassType() ? typeBounds.getClass() : typeBounds));
            treenode.setType(typeBounds);
            return objectCreator.createRandomObject(treenode);

        }

        return null;

    }
}
