package org.unitils.objectvalidation.objectcreator.generator;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.generator.helper.GeneratorHelper;
import org.unitils.objectvalidation.utils.TreeNode;

import sun.reflect.generics.reflectiveObjects.WildcardTypeImpl;


/**
 * Generates objects of type {@link WildcardTypeImpl}.
 *
 * @author Willemijn Wouters
 *
 * @since 1.1.8
 *
 */
public class WildCardTypeGenerator implements Generator {

    private ObjectCreator objectCreator;



    /**
     * @param objectCreator
     */
    protected WildCardTypeGenerator(ObjectCreator objectCreator) {
        this.objectCreator = objectCreator;
    }

    /**
     * @see org.unitils.objectvalidation.objectcreator.generator.Generator#generateObject(java.lang.Class, java.util.List, java.util.List, java.util.List)
     */
    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses, List<TreeNode> genericSubTypes) throws Exception {
        if (WildcardTypeImpl.class.isAssignableFrom(clazz)) {
            return generateObjectFromWildCard((WildcardTypeImpl) genericSubTypes.get(0).getType());
        }
        return null;
    }

    public Object generateObjectFromWildCard(WildcardTypeImpl wildCard) {
        Set<Class<?>> classesParamType = new HashSet<Class<?>>();
        classesParamType = (Set<Class<?>>) getClassesOfSubtypes(wildCard, classesParamType);
        classesParamType = getClassesOfSuperType(wildCard, classesParamType);

        Class<?> pickedClass = null;
        if (CollectionUtils.isEmpty(classesParamType)) {
            pickedClass = Object.class;
        } else {
            Random random = new Random();

            List<Class<?>> tempClasses = new ArrayList<Class<?>>(classesParamType);
            pickedClass = tempClasses.get(random.nextInt(tempClasses.size()));
        }

        return objectCreator.createRandomObject(pickedClass);
    }

    /**
     * Get the subtypes of a class (based on a wildcard).
     *
     * @param wildcard: the wildcard of the generic
     * @param allClasses: A collection where the {@link Generator} should add the found classes.
     * @return {@link Set}
     */
    protected Set<?> getClassesOfSubtypes(WildcardTypeImpl wildcard, Set<?> allClasses) {

        for (Type type : wildcard.getUpperBounds()) {
            allClasses = GeneratorHelper.getClassesOfSubtypes((Class<?>) type, allClasses);
        }

        return allClasses;
    }

    /**
     * An {@link WildcardTypeImpl} can have multiple lowerbounds (super).
     *
     * @param wildcard: the wildcard of the generic
     * @param allClasses: A collection where the {@link Generator} should add the found classes.
     * @return {@link Set}
     */
    protected Set<Class<?>> getClassesOfSuperType(WildcardTypeImpl wildcard, Set<Class<?>> allClasses) {
        for (Type type : wildcard.getLowerBounds()) {
            allClasses = GeneratorHelper.getClassesOfSuperType((Class<?>) type, allClasses);
        }

        return allClasses;
    }

}
