package org.unitils.objectvalidation.rules;


import java.lang.reflect.Method;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.objectvalidation.ObjectCloner;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.Rule;
import org.unitils.reflectionassert.ReflectionAssert;
import org.unitils.util.ReflectionUtils;


/**
 * This class checks if the toString() method of a cloned object stays the same or not.
 * 
 * @author Willemijn Wouters
 * 
 * @since 1.1.6
 * 
 * @see <a href="http://sourceforge.net/p/unitilsobjectvalidation/wiki/Home/">Object Validation module</a>
 * 
 */
public class NonMutatingToStringRule implements Rule {
    private static final Log LOGGER = LogFactory.getLog(NonMutatingToStringRule.class);


    private ObjectCreator objectCreator;
    private ObjectCloner objectCloner;


    /**
     * @param randomFactory
     */
    public NonMutatingToStringRule(ObjectCreator randomFactory, ObjectCloner objectCloner) {
        this.objectCreator = randomFactory;
        this.objectCloner = objectCloner;
    }

    /**
     * @see org.unitils.objectvalidation.Rule#validate(java.lang.Class)
     */
    @Override
    public void validate(Class<?> classToValidate) {
        Method method = ReflectionUtils.getMethod(classToValidate, "toString", false);

        if (method != null) {


            Object value = objectCreator.createRandomObject(classToValidate);
            Object clone = objectCloner.deepClone(value);
            String clonedValueToString = value.toString();

            for (int i = 0; i < 5; i++) {
                ReflectionAssert.assertReflectionEquals("The toString gives a different output after " + i + " calls", clonedValueToString, value.toString());
                ReflectionAssert.assertReflectionEquals("The content of the object changes when the to string is called " + i + " times", clone, value);
                
            }
        } else {
            LOGGER.debug("toString() not found");
        }

    }

}
