/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator.generator;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.generator.Generator;
import org.unitils.objectvalidation.objectcreator.generator.helper.GeneratorHelper;
import org.unitils.objectvalidation.utils.TreeNode;

public class CollectionGenerator
implements Generator {
    private static final int MINIMUM = 1;
    private static final int MAXIMUM = 10;
    private final ObjectCreator objectCreator;

    public CollectionGenerator(ObjectCreator objectCreator) {
        this.objectCreator = objectCreator;
    }

    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses, List<TreeNode> genericSubTypes) throws Exception {
        if (clazz.isInterface()) {
            if (clazz.isAssignableFrom(Map.class)) {
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                for (int i = 0; i < CollectionGenerator.numberOfObjectsToGenerate(); ++i) {
                    Object key = this.createRandomObject(genericSubTypes.isEmpty() ? Object.class : genericSubTypes.get(0).getValue());
                    Object value = this.createRandomObject(genericSubTypes.isEmpty() ? Object.class : genericSubTypes.get(1).getValue());
                    hashMap.put(key, value);
                }
                return hashMap;
            }
            if (clazz.isAssignableFrom(List.class)) {
                return this.createListOf(genericSubTypes.isEmpty() ? new TreeNode(Object.class) : genericSubTypes.get(0));
            }
            if (clazz.isAssignableFrom(Set.class)) {
                if (CollectionUtils.isEmpty(genericSubTypes)) {
                    return new HashSet(this.createListOf(new TreeNode(Object.class)));
                }
                return new HashSet(this.createListOf(genericSubTypes.get(0)));
            }
        }
        if (clazz.isArray()) {
            TreeNode node = null;
            node = genericSubTypes.isEmpty() ? GeneratorHelper.createTreenode(Object.class) : (genericSubTypes.get(0).getValue().isArray() ? GeneratorHelper.createTreenode(genericSubTypes.get(0).getValue().getComponentType()) : GeneratorHelper.createTreenode(genericSubTypes.get(0).getValue()));
            List listOfObjects = this.createListOf(node);
            Object newInstance = Array.newInstance(node.getValue(), listOfObjects.size());
            for (int i = 0; i < listOfObjects.size(); ++i) {
                Array.set(newInstance, i, listOfObjects.get(i));
            }
            return newInstance;
        }
        return null;
    }

    private List createListOf(TreeNode subTypes) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < CollectionGenerator.numberOfObjectsToGenerate(); ++i) {
            TreeNode treenode = GeneratorHelper.createTreenode(subTypes.getType() == null ? subTypes.getValue() : subTypes.getType());
            treenode.setGenericSubtype(Arrays.asList(treenode));
            list.add(this.objectCreator.createRandomObject(treenode));
        }
        return list;
    }

    private <T> T createRandomObject(Class<T> clazz) {
        if (clazz == null) {
            return (T)this.objectCreator.createRandomObject((Type)((Object)Object.class));
        }
        return (T)this.objectCreator.createRandomObject(clazz);
    }

    private static int numberOfObjectsToGenerate() {
        return 1 + (int)(Math.random() * 10.0);
    }
}

