/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator.generator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.unitils.objectvalidation.objectcreator.generator.Generator;
import org.unitils.objectvalidation.utils.TreeNode;

public class CompositeGenerator
implements Generator {
    private List<Generator> generators;

    public CompositeGenerator(List<Generator> generators) {
        this.generators = generators;
    }

    public CompositeGenerator() {
        this(new ArrayList<Generator>());
    }

    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses, List<TreeNode> genericSubTypes) throws Exception {
        for (Generator generator : this.generators) {
            Object result = generator.generateObject(clazz, input, inputClasses, genericSubTypes);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void addGenerators(Generator ... generator) {
        this.generators.addAll(Arrays.asList(generator));
    }

    public List<Generator> getGenerators() {
        return this.generators;
    }
}

