/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator.generator.helper;

import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.easymock.classextension.internal.objenesis.ObjenesisStd;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.scanners.SubTypesScanner;
import org.unitils.objectvalidation.objectcreator.generator.helper.ClassPathHelperExtended;
import org.unitils.objectvalidation.reflect.TypeWrapper;
import org.unitils.objectvalidation.utils.TreeNode;

public class GeneratorHelper {
    private static final Log LOGGER = LogFactory.getLog(GeneratorHelper.class);
    private static GeneratorHelper subSuperTypes;
    private ObjenesisStd objenesisStd;
    private final Reflections reflections = new Reflections(new Object[]{new SubTypesScanner(false), ClassPathHelperExtended.forProject(this.getClass().getClassLoader())});

    public static Set<Class<?>> getClassesOfSuperType(Class<?> clzz, Set<Class<?>> allClasses) {
        return GeneratorHelper.getInstance().getClassesOfSuperTypeInstance(clzz, allClasses);
    }

    public static Set<Class<?>> compareSubtypesSets(Set<?> set1, Set<?> set2) {
        return new HashSet(CollectionUtils.intersection(set1, set2));
    }

    public static Object generateSubTypesObject(Class<?> classForType) {
        return GeneratorHelper.getInstance().generateSubTypesObjectInstance(classForType);
    }

    public static Set<?> getClassesOfSubtypes(Class<?> clzz, Set<?> allClasses) {
        return GeneratorHelper.getInstance().getClassesOfSubtypesInstance(clzz, allClasses);
    }

    public static Set<Class<? extends Object>> getSetWithClassesThatOverridesASpecificMethod(Set<Class<? extends Object>> set, String methodName, Class<?> ... parameterTypes) {
        HashSet<Class<? extends Object>> temp = new HashSet<Class<? extends Object>>(set);
        for (Class<? extends Object> clzz : set) {
            try {
                Method method = clzz.getMethod(methodName, parameterTypes);
                if (method.getDeclaringClass().equals(clzz)) continue;
                temp.remove(clzz);
            }
            catch (NoSuchMethodException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (SecurityException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return temp;
    }

    public static Object pickAndCreateAnObjectFromASet(Set<Class<?>> collClasses) {
        return GeneratorHelper.getInstance().pickAndCreateAnObjectFromASetInstance(collClasses);
    }

    public static GeneratorHelper getInstance() {
        if (subSuperTypes == null) {
            subSuperTypes = new GeneratorHelper();
        }
        return subSuperTypes;
    }

    private GeneratorHelper() {
        this.objenesisStd = new ObjenesisStd();
    }

    protected Set<Class<?>> getClassesOfSuperTypeInstance(Class<?> clzz, Set<Class<?>> allClasses) {
        Set<Class<?>> tempSuperTypes = ReflectionUtils.getAllSuperTypes(clzz, (Predicate[])null);
        allClasses = CollectionUtils.isEmpty(allClasses) ? tempSuperTypes : GeneratorHelper.compareSubtypesSets(allClasses, tempSuperTypes);
        return allClasses;
    }

    protected Object generateSubTypesObjectInstance(Class<?> classForType) {
        Set<Object> allClasses = new HashSet();
        if ((allClasses = GeneratorHelper.getClassesOfSubtypes(classForType, allClasses)).isEmpty() && !classForType.isInterface() && !Modifier.isAbstract(classForType.getModifiers())) {
            allClasses.add(classForType);
        }
        return GeneratorHelper.pickAndCreateAnObjectFromASet(allClasses);
    }

    protected Set<?> getClassesOfSubtypesInstance(Class<?> clzz, Set<?> allClasses) {
        try {
            Set<Class<?>> tempSubtypes = this.reflections.getSubTypesOf(clzz);
            allClasses = CollectionUtils.isEmpty(allClasses) ? tempSubtypes : GeneratorHelper.compareSubtypesSets(allClasses, tempSubtypes);
        }
        catch (ReflectionsException e) {
            LOGGER.error((Object)"Something went wrong with finding a subtype", (Throwable)e);
        }
        return allClasses;
    }

    protected Object pickAndCreateAnObjectFromASetInstance(Set<Class<?>> collClasses) {
        try {
            if (!(CollectionUtils.isEmpty(collClasses) || collClasses.size() == 1 && collClasses.contains(Object.class))) {
                return this.createRandomObjects(collClasses);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Something went wrong with creating one of the genrerics", (Throwable)e);
        }
        Set<Class<?>> asList = this.reflections.getSubTypesOf(Object.class);
        asList = GeneratorHelper.getSetWithClassesThatOverridesASpecificMethod((Set<Class<? extends Object>>)asList, "equals", Object.class);
        asList = GeneratorHelper.getSetWithClassesThatOverridesASpecificMethod(asList, "hashCode", new Class[0]);
        return this.createRandomObjects(asList);
    }

    protected Object createRandomObjects(Set<Class<?>> classes) {
        ArrayList tempClasses = new ArrayList();
        for (Class<?> clzz : classes) {
            if (clzz.isInterface()) continue;
            tempClasses.add(clzz);
        }
        if (tempClasses.isEmpty()) {
            tempClasses.addAll(classes);
        }
        Random random = new Random();
        Class obj = (Class)tempClasses.get(random.nextInt(tempClasses.size()));
        return this.objenesisStd.getInstantiatorOf(obj).newInstance();
    }

    public static List<TreeNode> createNodes(Type type) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        treeNodes.add(GeneratorHelper.createTreenode(type));
        return treeNodes;
    }

    public static TreeNode createTreenode(Type type) {
        TypeWrapper wrapper = new TypeWrapper(type);
        if (!wrapper.isClassType()) {
            TreeNode node = new TreeNode(type.getClass());
            node.setType(type);
            return node;
        }
        TreeNode node = new TreeNode((Class)type);
        node.setType(type);
        return node;
    }

    public static TreeNode createTreenode(Field field) {
        if (!field.getGenericType().getClass().equals(Class.class)) {
            return GeneratorHelper.createTreenode(field.getGenericType());
        }
        return GeneratorHelper.createTreenode(field.getType());
    }

    public static List<TreeNode> createTreenodes(Field field) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        list.add(GeneratorHelper.createTreenode(field));
        return list;
    }
}

