package org.unitils.objectvalidation.objectcreator.generator;

import org.unitils.objectvalidation.ObjectCreator;

/**
 *
 * The DefaultGenerator is a composite Generator with a pre defiend set of generators. The supported generators are {@link EnumGenerator},
 * {@link PrimitiveGenerator}, {@link LastResortGenerator}
 *
 * @author Jeroen Horemans
 * @since Feb 20, 2012
 */
public class DefaultGenerator extends CompositeGenerator {

    public DefaultGenerator(ObjectCreator objectCreator) {
        addGenerators(new EnumGenerator(), new PrimitiveGenerator(), new CollectionGenerator(objectCreator), new ParameterizedTypeGenerator(objectCreator), new TypeVariableImplGenerator(objectCreator), new WildCardTypeGenerator(objectCreator), new BuilderGenerator(objectCreator), new LastResortGenerator());
    }
}
