package org.unitils.objectvalidation.objectcreator.generator.helper;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reflections.util.ClasspathHelper;
import org.unitils.core.Unitils;
import org.unitils.util.PropertyUtils;


/**
 * Extention for {@link ClasspathHelper}.
 * This class let the user choose in which packages the pojos are.
 * Default: target/classes
 * 
 * @author Willemijn Wouters
 * 
 * @since 1.1.6
 * 
 */
public class ClassPathHelperExtended extends ClasspathHelper {
    private static final Log LOGGER = LogFactory.getLog(ClassPathHelperExtended.class);
    
    public static final String PROPKEY_PACKAGEPOJOS = "org.unitils.objectvalidation.packagepojos";
    
    /**
     * this method checks in the unitils.properties if there is a property {@link ClassPathHelperExtended#PROPKEY_PACKAGEPOJOS}.
     * If that property isn't there than all the classes from the default folder ("target/classes") is loaded.
     * 
     * @param classLoaders: The classloaders from the GenericsGenerator class.
     * @return {@link Collection}
     */
    public static Collection<URL> forProject(ClassLoader classLoaders) {
        
        List<String> locationsPojos = PropertyUtils.getStringList(PROPKEY_PACKAGEPOJOS,  Unitils.getInstance().getConfiguration(), false);
        
        if (locationsPojos.isEmpty()) {
            locationsPojos.add("target/classes");
        }
        
        List<URL> urls = new ArrayList<URL>();
        
        for (String locationPojos : locationsPojos) {
            try {
                urls.add(new File(locationPojos).toURI().toURL());
            } catch (MalformedURLException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
        return urls;
    
    }
}
