package org.unitils.objectvalidation.rules;

import static java.lang.reflect.Modifier.isStatic;
import static org.junit.Assert.assertTrue;

import java.lang.reflect.Method;
import org.unitils.objectvalidation.Rule;


/**
 * Rule to check that there is only static methods declared in the class.
 * 
 * @author Matthieu Mestrez
 * @since Oct 24, 2013
 */
public class OnlyStaticMethodsRule implements Rule {

    @Override
    public void validate(Class<?> classToValidate) {
        Method[] methods = classToValidate.getDeclaredMethods();
        for (Method method : methods) {
            assertTrue("Method " + method.getName() + " is not static.", isStatic(method.getModifiers()));
        }
    }

}
