package org.unitils.objectvalidation.rules;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.lang.reflect.Method;

import org.unitils.objectvalidation.Rule;


/**
 * Rule to check that the toString method is well overriden in the tested class.
 * 
 * @author Matthieu Mestrez
 * @since Oct 23, 2013
 */
public class ToStringHasToBeOverridenRule implements Rule {

    @Override
    public void validate(Class<?> classToValidate) {
        Method toStringMethod;
        try {
            toStringMethod = classToValidate.getDeclaredMethod("toString");
            assertNotNull("toString method has to be Overriden", toStringMethod);
        } catch (SecurityException e) {
            fail("Could not be read due to security reasons.\n" + e.getMessage());
        } catch (NoSuchMethodException e) {
            fail("Does not contain toString method. It should be overriden.");
        }
    }
    
}
