/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.unitils.core.TestListener;
import org.unitils.objectvalidation.EqualsHashCodeValidator;
import org.unitils.objectvalidation.ObjectValidationRules;
import org.unitils.objectvalidation.ObjectValidationRulesCollection;
import org.unitils.objectvalidation.ObjectValidator;
import org.unitils.objectvalidation.Rule;
import org.unitils.objectvalidation.utils.Utils;
import org.unitils.util.ReflectionUtils;

public class ValidationModuleTestListener
extends TestListener {
    private ObjectValidationRulesCollection validationRulesCollection;

    public ValidationModuleTestListener(ObjectValidationRulesCollection validationRulesCollection) {
        Utils.checkNotNull(((Object)((Object)this)).getClass().getName() + " must have validationRules", validationRulesCollection);
        this.validationRulesCollection = validationRulesCollection;
    }

    public void beforeTestMethod(Object testObject, Method testMethod) {
        this.prepareObjectValidatorFieldIn(testObject);
        super.afterCreateTestObject(testObject);
    }

    private void prepareObjectValidatorFieldIn(Object testClass) {
        List<Field> objectValidatorFields = Utils.findOneAndOnlyFieldForAnnotation(testClass.getClass(), ObjectValidationRules.class, ObjectValidator.class);
        for (Field objectValidatorField : objectValidatorFields) {
            ObjectValidator validator = this.createObjectValidator(objectValidatorField);
            ReflectionUtils.setFieldValue((Object)testClass, (Field)objectValidatorField, (Object)validator);
        }
    }

    private ObjectValidator createObjectValidator(Field objectValidatorField) {
        List<Rule> rulesToValidate = this.buildRulesForField(objectValidatorField);
        List<EqualsHashCodeValidator> equalsHashCodeValidator = this.buildEqualsHashCodeValidator(objectValidatorField);
        return new ObjectValidator(rulesToValidate, equalsHashCodeValidator);
    }

    private List<Rule> buildRulesForField(Field field) {
        ObjectValidationRules annotation = field.getAnnotation(ObjectValidationRules.class);
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (annotation.replacementRules() != null && annotation.replacementRules().length > 0) {
            rules.addAll(this.constructRules(annotation.replacementRules()));
        } else {
            rules.addAll(this.validationRulesCollection.getRules());
        }
        if (annotation.additionalRules() != null && annotation.additionalRules().length > 0) {
            rules.addAll(this.constructRules(annotation.additionalRules()));
        }
        return rules;
    }

    private List<EqualsHashCodeValidator> buildEqualsHashCodeValidator(Field field) {
        ObjectValidationRules annotation = field.getAnnotation(ObjectValidationRules.class);
        ArrayList<EqualsHashCodeValidator> validator = new ArrayList<EqualsHashCodeValidator>();
        if (annotation.replacementRules() != null && annotation.replacementRules().length > 0) {
            validator.addAll(this.constructEqualsHashCodeValidator(annotation.replacementRules()));
        } else {
            validator.add(this.validationRulesCollection.getEqualsHashCodeValidator());
        }
        if (annotation.additionalRules() != null && annotation.additionalRules().length > 0) {
            validator.addAll(this.constructEqualsHashCodeValidator(annotation.additionalRules()));
        }
        return validator;
    }

    private List<Rule> constructRules(Class<? extends ObjectValidationRulesCollection>[] rules) {
        ArrayList<Rule> objectValidationRules = new ArrayList<Rule>();
        for (Class<? extends ObjectValidationRulesCollection> ruleCollection : rules) {
            objectValidationRules.addAll(Utils.toRulesCollection(ruleCollection).getRules());
        }
        return objectValidationRules;
    }

    private List<EqualsHashCodeValidator> constructEqualsHashCodeValidator(Class<? extends ObjectValidationRulesCollection>[] rules) {
        ArrayList<EqualsHashCodeValidator> validators = new ArrayList<EqualsHashCodeValidator>();
        for (Class<? extends ObjectValidationRulesCollection> ruleCollection : rules) {
            validators.add(Utils.toEqualsHashCodeValidator(ruleCollection));
        }
        return validators;
    }
}

