/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation;

import java.util.ArrayList;
import java.util.List;
import org.unitils.objectvalidation.ValidationMessage;

public class ValidationResult {
    private Class<?> validatedClass;
    private List<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();

    private ValidationResult(Class<?> validatedClass) {
        this.validatedClass = validatedClass;
    }

    void addValidationMessage(ValidationMessage validationMessage) {
        this.validationMessages.add(validationMessage);
    }

    boolean isValid() {
        return this.validationMessages.isEmpty();
    }

    public String toString() {
        return this.validatedClass.getName() + (this.isValid() ? " is valid." : " is not valid. List of validation messages :\n" + this.validationMessagesAsString());
    }

    private String validationMessagesAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ValidationMessage validationMessage : this.validationMessages) {
            stringBuilder.append("    " + validationMessage.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static ValidationResultBuilder buildValidationResultForClass(Class<?> clazz) {
        return new ValidationResultBuilder(clazz);
    }

    public static class ValidationResultBuilder {
        private ValidationResult validationResult;

        public ValidationResultBuilder(Class<?> clazz) {
            this.validationResult = new ValidationResult(clazz);
        }

        public ValidationResultBuilder andMessage(ValidationMessage validationMessage) {
            this.validationResult.addValidationMessage(validationMessage);
            return this;
        }

        public ValidationResult build() {
            return this.validationResult;
        }
    }
}

