/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator;

import java.util.List;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.generator.CompositeGenerator;
import org.unitils.objectvalidation.objectcreator.generator.Generator;

public abstract class BaseObjectCreator
implements ObjectCreator {
    private Generator generator;

    public BaseObjectCreator() {
        this.generator = new CompositeGenerator();
    }

    public BaseObjectCreator(Generator[] generators) {
        CompositeGenerator gen = new CompositeGenerator();
        gen.addGenerators(generators);
        this.generator = gen;
    }

    @Override
    public <T> T getGeneratorOfType(Class<T> generatorType) {
        return this.getGeneratorOfType(generatorType, ((CompositeGenerator)this.generator).getGenerators());
    }

    public <T> T getGeneratorOfType(Class<T> generatorType, List<Generator> generators) {
        for (Generator tempGenerator : generators) {
            T result;
            if (tempGenerator.getClass().isAssignableFrom(generatorType)) {
                return (T)tempGenerator;
            }
            if (!(tempGenerator instanceof CompositeGenerator) || (result = this.getGeneratorOfType(generatorType, ((CompositeGenerator)tempGenerator).getGenerators())) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void addGenerators(Generator ... generators) {
        CompositeGenerator gen = (CompositeGenerator)this.generator;
        gen.addGenerators(generators);
    }

    @Override
    public List<Generator> getGenerators() {
        return ((CompositeGenerator)this.generator).getGenerators();
    }

    @Override
    public Generator getGenerator() {
        return this.generator;
    }
}

