/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.easymock.classextension.internal.objenesis.ObjenesisStd;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.BaseObjectCreator;
import org.unitils.objectvalidation.objectcreator.generator.Generator;
import org.unitils.objectvalidation.objectcreator.generator.helper.GeneratorHelper;
import org.unitils.objectvalidation.utils.ObjectCreatorTypeWrapper;
import org.unitils.objectvalidation.utils.TreeNode;
import org.unitils.util.ReflectionUtils;

public class ObjectCreatorMockedFieldsImpl
extends BaseObjectCreator
implements ObjectCreator {
    private static final Log LOGGER = LogFactory.getLog(ObjectCreatorMockedFieldsImpl.class);
    private int instances = 0;

    public ObjectCreatorMockedFieldsImpl() {
    }

    public ObjectCreatorMockedFieldsImpl(Generator ... generators) {
        super(generators);
    }

    @Override
    public Object createRandomObject(Type type) {
        Object randomObject = null;
        ObjectCreatorTypeWrapper typeWrapper = new ObjectCreatorTypeWrapper(type);
        if (typeWrapper.isPrimitive() || typeWrapper.isString() || typeWrapper.getWrappedType().getClass().isEnum()) {
            try {
                return this.getGenerator().generateObject(typeWrapper.getClassOfType(), new ArrayList<Object>(), new ArrayList(), new ArrayList<TreeNode>());
            }
            catch (Exception e) {
                LOGGER.error((Object)("The " + this.getClass().getSimpleName() + " couldn't generate the following class: " + typeWrapper.getClassOfType()), (Throwable)e);
            }
        }
        if (typeWrapper.isFinal() && !typeWrapper.isArray()) {
            return new ObjenesisStd().getInstantiatorOf(typeWrapper.getClassOfType()).newInstance();
        }
        if (this.instances == 0) {
            ++this.instances;
            if (this.checkForCreatingAnInstance(typeWrapper)) {
                randomObject = this.createInstance(typeWrapper);
                for (Field field : ReflectionUtils.getAllFields(typeWrapper.getClassOfType())) {
                    if (this.isConstant(field)) continue;
                    field.setAccessible(true);
                    List<TreeNode> genericSubTypes = GeneratorHelper.createTreenodes(field);
                    Object generatedObject = this.createObject(genericSubTypes);
                    ReflectionUtils.setFieldValue((Object)randomObject, (Field)field, (Object)generatedObject);
                }
            } else {
                randomObject = this.createObject(type);
            }
            --this.instances;
        } else {
            randomObject = this.createObject(type);
        }
        return randomObject;
    }

    protected boolean checkForCreatingAnInstance(ObjectCreatorTypeWrapper wrapper) {
        return (wrapper.isClassType() || wrapper.isInterface()) && !wrapper.isPrimitive() && !wrapper.isString() && !wrapper.isEnum() && !wrapper.isParameterizedType() && !wrapper.isArray();
    }

    protected Object createObject(Type type) {
        return this.createObject(GeneratorHelper.createNodes(type));
    }

    protected Object createObject(List<TreeNode> nodes) {
        try {
            return this.getGenerator().generateObject(nodes.get(0).getValue(), new ArrayList<Object>(), new ArrayList(), nodes);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Something went wrong with creating " + nodes.get(0).getValue()), (Throwable)e);
            return null;
        }
    }

    @Override
    public Object createRandomObject(TreeNode bean) {
        return this.createRandomObject(bean.getType());
    }

    Object createInstance(ObjectCreatorTypeWrapper typeWrapper) {
        Constructor<?> constructor = this.getConstructor(typeWrapper.getClassOfType());
        if (this.constructorNotEmpty(constructor)) {
            constructor.setAccessible(true);
            int i = 0;
            Class[] classes = (Class[])Array.newInstance(Class.class, constructor.getGenericParameterTypes().length);
            Object[] values = (Object[])Array.newInstance(Object.class, constructor.getGenericParameterTypes().length);
            for (Type parameterType : constructor.getGenericParameterTypes()) {
                ObjectCreatorTypeWrapper type = new ObjectCreatorTypeWrapper(parameterType);
                classes[i] = type.getClassOfType();
                values[i] = this.createObject(type.getWrappedType());
                ++i;
            }
            return ReflectionUtils.createInstanceOfType(typeWrapper.getClassOfType(), (boolean)true, (Class[])classes, (Object[])values);
        }
        if (this.isDefaultConstructor(constructor)) {
            return ReflectionUtils.createInstanceOfType(typeWrapper.getClassOfType(), (boolean)true);
        }
        return null;
    }

    protected boolean constructorNotEmpty(Constructor<?> constructor) {
        return constructor != null && constructor.getParameterTypes().length > 0;
    }

    protected boolean isDefaultConstructor(Constructor<?> constructor) {
        return constructor != null && constructor.getParameterTypes().length == 0;
    }

    protected Constructor<?> getConstructor(Class<?> clzz) {
        for (Constructor<?> constructor : clzz.getConstructors()) {
            if (constructor.isSynthetic()) continue;
            return constructor;
        }
        return null;
    }

    protected boolean isPrimitive(ObjectCreatorTypeWrapper wrapper) {
        return wrapper.isPrimitive() || wrapper.isString();
    }

    protected boolean isConstant(Field field) {
        return Modifier.isFinal(field.getModifiers()) && Modifier.isStatic(field.getModifiers());
    }
}

