/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator.generator;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.generator.CollectionGenerator;
import org.unitils.objectvalidation.objectcreator.generator.Generator;
import org.unitils.objectvalidation.objectcreator.generator.helper.GeneratorHelper;
import org.unitils.objectvalidation.utils.ObjectCreatorTypeWrapper;
import org.unitils.objectvalidation.utils.TreeNode;

public class ParameterizedTypeGenerator
implements Generator {
    private ObjectCreator objectCreator;

    public ParameterizedTypeGenerator(ObjectCreator objectCreator) {
        this.objectCreator = objectCreator;
    }

    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses, List<TreeNode> genericSubTypes) throws Exception {
        if (ParameterizedType.class.isAssignableFrom(clazz) && !CollectionUtils.isEmpty(genericSubTypes)) {
            return this.createParameterizedType((ParameterizedType)genericSubTypes.get(0).getType(), input, inputClasses);
        }
        return null;
    }

    public Object createParameterizedType(ParameterizedType type, List<Object> input, List<Class<?>> inputClasses) throws Exception {
        ObjectCreatorTypeWrapper typeWrapper = new ObjectCreatorTypeWrapper(type.getRawType());
        if (this.isCollection(typeWrapper)) {
            TreeNode node = GeneratorHelper.createTreenode(type.getRawType());
            ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
            for (Type subtype : type.getActualTypeArguments()) {
                nodes.add(GeneratorHelper.createTreenode(subtype));
            }
            node.setGenericSubtype(nodes);
            return this.objectCreator.getGeneratorOfType(CollectionGenerator.class).generateObject((Class)type.getRawType(), input, inputClasses, nodes);
        }
        return this.objectCreator.createRandomObject(GeneratorHelper.createTreenode(type.getRawType()));
    }

    protected boolean isCollection(ObjectCreatorTypeWrapper typeWrapper) {
        return typeWrapper.isArray() || typeWrapper.isList() || typeWrapper.isMap() || typeWrapper.isSet();
    }
}

