/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator.generator;

import java.lang.reflect.Type;
import java.util.List;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.generator.Generator;
import org.unitils.objectvalidation.reflect.TypeWrapper;
import org.unitils.objectvalidation.utils.TreeNode;
import sun.reflect.generics.reflectiveObjects.TypeVariableImpl;

public class TypeVariableImplGenerator
implements Generator {
    private ObjectCreator objectCreator;

    public TypeVariableImplGenerator(ObjectCreator objectCreator) {
        this.objectCreator = objectCreator;
    }

    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses, List<TreeNode> genericSubTypes) throws Exception {
        if (this.shouldCreateThisObject(clazz, genericSubTypes)) {
            return this.createObjectOfTypeVariableImpl((TypeVariableImpl)genericSubTypes.get(0).getType());
        }
        return null;
    }

    protected boolean shouldCreateThisObject(Class<?> clazz, List<TreeNode> genericSubTypes) {
        return TypeVariableImpl.class.isAssignableFrom(clazz) && !genericSubTypes.isEmpty() && genericSubTypes.get(0).getType() instanceof TypeVariableImpl;
    }

    public Object createObjectOfTypeVariableImpl(TypeVariableImpl<?> type) {
        Type[] bounds = type.getBounds();
        if (bounds.length > 0) {
            Class<?> typeBounds = bounds[0];
            TreeNode treenode = new TreeNode(new TypeWrapper(typeBounds).isClassType() ? typeBounds.getClass() : typeBounds);
            treenode.setType(typeBounds);
            return this.objectCreator.createRandomObject(treenode);
        }
        return null;
    }
}

