/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.objectcreator.generator;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.objectcreator.generator.Generator;
import org.unitils.objectvalidation.objectcreator.generator.helper.GeneratorHelper;
import org.unitils.objectvalidation.utils.TreeNode;
import sun.reflect.generics.reflectiveObjects.WildcardTypeImpl;

public class WildCardTypeGenerator
implements Generator {
    private ObjectCreator objectCreator;

    protected WildCardTypeGenerator(ObjectCreator objectCreator) {
        this.objectCreator = objectCreator;
    }

    @Override
    public Object generateObject(Class<?> clazz, List<Object> input, List<Class<?>> inputClasses, List<TreeNode> genericSubTypes) throws Exception {
        if (WildcardTypeImpl.class.isAssignableFrom(clazz)) {
            return this.generateObjectFromWildCard((WildcardTypeImpl)genericSubTypes.get(0).getType());
        }
        return null;
    }

    public Object generateObjectFromWildCard(WildcardTypeImpl wildCard) {
        Set<Object> classesParamType = new HashSet();
        classesParamType = this.getClassesOfSubtypes(wildCard, classesParamType);
        classesParamType = this.getClassesOfSuperType(wildCard, classesParamType);
        Class pickedClass = null;
        if (CollectionUtils.isEmpty(classesParamType)) {
            pickedClass = Object.class;
        } else {
            Random random = new Random();
            ArrayList tempClasses = new ArrayList(classesParamType);
            pickedClass = (Class)tempClasses.get(random.nextInt(tempClasses.size()));
        }
        return this.objectCreator.createRandomObject(pickedClass);
    }

    protected Set<?> getClassesOfSubtypes(WildcardTypeImpl wildcard, Set<?> allClasses) {
        for (Type type : wildcard.getUpperBounds()) {
            allClasses = GeneratorHelper.getClassesOfSubtypes((Class)type, allClasses);
        }
        return allClasses;
    }

    protected Set<Class<?>> getClassesOfSuperType(WildcardTypeImpl wildcard, Set<Class<?>> allClasses) {
        for (Type type : wildcard.getLowerBounds()) {
            allClasses = GeneratorHelper.getClassesOfSuperType((Class)type, allClasses);
        }
        return allClasses;
    }
}

