/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.rules;

import org.junit.Assert;
import org.unitils.objectvalidation.ObjectCloner;
import org.unitils.objectvalidation.ObjectCreator;
import org.unitils.objectvalidation.Rule;
import org.unitils.objectvalidation.utils.Utils;

public class HashCodeComplientRule
implements Rule {
    private ObjectCreator randomFactory;
    private ObjectCloner objectCloner;

    public HashCodeComplientRule(ObjectCreator randomFactory, ObjectCloner objectCloner) {
        this.randomFactory = randomFactory;
        this.objectCloner = objectCloner;
    }

    @Override
    public void validate(Class<?> bean) {
        Object firstObject = this.randomFactory.createRandomObject(bean);
        Object equalsObject = this.objectCloner.deepClone(firstObject);
        Object differentObject = this.randomFactory.createRandomObject(bean);
        this.checkRules(firstObject, equalsObject, differentObject);
    }

    private void checkRules(Object firstObject, Object equalsObject, Object differentObject) {
        Utils.checkNotNull(firstObject, "firstInstance is not supposed to be null.");
        Utils.checkNotNull(equalsObject, "secondInstance is not supposed to be null.");
        Utils.checkNotNull(differentObject, "thirdInstance is not supposed to be null.");
        this.checkConsistency(firstObject);
        this.checkTwoEqualsObjectsProduceSameNumber(firstObject, equalsObject);
    }

    public void checkConsistency(Object object) {
        int initialHashCode = object.hashCode();
        Assert.assertEquals((String)"Consistent hashcode test fails", (long)initialHashCode, (long)object.hashCode());
        Assert.assertEquals((String)"Consistent hashcode test fails", (long)initialHashCode, (long)object.hashCode());
    }

    public void checkTwoEqualsObjectsProduceSameNumber(Object firstObject, Object equalsObject) {
        int objectOneHashCode = firstObject.hashCode();
        int objectThreeHashCode = equalsObject.hashCode();
        Assert.assertEquals((String)"Equal object, return equal hashcode test fails", (long)objectOneHashCode, (long)objectThreeHashCode);
    }
}

