/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.rules;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.junit.Assert;
import org.unitils.objectvalidation.Rule;
import org.unitils.util.ReflectionUtils;

public final class NoPublicFieldsRule
implements Rule {
    @Override
    public void validate(Class<?> classToValidate) {
        for (Field fieldEntry : ReflectionUtils.getAllFields(classToValidate)) {
            boolean isFinal = Modifier.isFinal(fieldEntry.getModifiers());
            boolean isStatic = Modifier.isStatic(fieldEntry.getModifiers());
            boolean isPublic = Modifier.isPublic(fieldEntry.getModifiers());
            if (isFinal && isStatic || !isPublic) continue;
            Assert.fail((String)String.format("Public fields=[%s] not allowed", fieldEntry));
        }
    }
}

