/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.rules;

import java.lang.reflect.Method;
import org.junit.Assert;
import org.unitils.objectvalidation.Rule;

public class ToStringHasToBeOverridenRule
implements Rule {
    @Override
    public void validate(Class<?> classToValidate) {
        try {
            Method toStringMethod = classToValidate.getDeclaredMethod("toString", new Class[0]);
            Assert.assertNotNull((String)"toString method has to be Overriden", (Object)toStringMethod);
        }
        catch (SecurityException e) {
            Assert.fail((String)("Could not be read due to security reasons.\n" + e.getMessage()));
        }
        catch (NoSuchMethodException e) {
            Assert.fail((String)"Does not contain toString method. It should be overriden.");
        }
    }
}

