/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.objectvalidation.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.unitils.objectvalidation.reflect.TypeWrapper;

public class ObjectCreatorTypeWrapper
extends TypeWrapper {
    public ObjectCreatorTypeWrapper(Type type) {
        super(type);
        if (type == null) {
            throw new NullPointerException("TreeNode cannot be constructed with a null value");
        }
    }

    public Class<?> getTypeOfArray() {
        return ((Class)this.getWrappedType()).getComponentType();
    }

    public Class<?> getTypeOfSingleParameterCollection() {
        if (this.isArray()) {
            return this.getTypeOfArray();
        }
        if (this.isList() || this.isSet()) {
            return this.getSingleGenericClass();
        }
        return null;
    }

    public Type getTypeForKeyOfMap() {
        if (this.isMap()) {
            Type[] types = ((ParameterizedType)this.wrappedType).getActualTypeArguments();
            return types[0];
        }
        return null;
    }

    public Type getTypeForValueOfMap() {
        if (this.isMap()) {
            Type[] types = ((ParameterizedType)this.wrappedType).getActualTypeArguments();
            return types[1];
        }
        return null;
    }

    public Class<?> getClassOfType() {
        if (this.isArray()) {
            return this.getTypeOfArray();
        }
        if (this.isClassType()) {
            return (Class)this.getWrappedType();
        }
        if (this.isParameterizedType()) {
            return (Class)((ParameterizedType)this.getWrappedType()).getRawType();
        }
        return null;
    }

    public boolean isArray() {
        return this.isClassType() && ((Class)this.getWrappedType()).isArray();
    }

    public boolean isList() {
        return this.hasRawType((Type)((Object)List.class));
    }

    public boolean isSet() {
        return this.hasRawType((Type)((Object)Set.class));
    }

    public boolean isMap() {
        return this.hasRawType((Type)((Object)Map.class));
    }

    public boolean isEnum() {
        return this.isClassType() && this.getClassOfType().isEnum();
    }

    public boolean isInterface() {
        return this.isClassType() && this.getClassOfType().isInterface();
    }

    public boolean isException() {
        return this.isAssignableTo((Type)((Object)Exception.class));
    }

    public boolean isUtilDate() {
        return Date.class.equals((Object)this.getWrappedType());
    }

    public boolean isSQLDate() {
        return java.sql.Date.class.equals((Object)this.getWrappedType());
    }

    public boolean isBoolean() {
        return this.isAssignableTo((Type)((Object)Boolean.class)) || this.isAssignableTo(Boolean.TYPE);
    }

    public boolean isString() {
        return this.isAssignableTo((Type)((Object)String.class));
    }

    protected boolean isNumber() {
        return this.isAssignableTo((Type)((Object)Number.class));
    }
}

