package org.unitils.selenium;

import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.CapabilityType;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.unitils.util.ReflectionUtils;


/**
 * 
 * @author Jeroen Horemans
 * @author Thomas De Rycke
 * @author Willemijn Wouters
 * 
 * @since 1.0.0
 *
 */
public class WebDriverFactory {
    private static final String BROWSERMESSAGE = "privacy.popups.showBrowserMessage";

    /**
     * The webdriver will be created in this method.
     * @param browserChoice
     * @return {@link WebDriver}
     */
    public static WebDriver createDriver(BrowserChoice browserChoice, String downloadPath, String fileType) {
        if (browserChoice == null || BrowserChoice.FIREFOX.equals(browserChoice)) {
            return createFireFoxDriver(downloadPath, fileType);
        } else {
            return ReflectionUtils.createInstanceOfType(browserChoice.getDriverClass(), true);
        }

    }
    protected static WebDriver createInternetExplorerDriver(String proxyUrl) {
        Proxy proxy = new Proxy();
        proxy.setHttpProxy(proxyUrl)
        .setFtpProxy(proxyUrl)
        .setSslProxy(proxyUrl)
        .setNoProxy("");
        DesiredCapabilities cap = new DesiredCapabilities();
        cap.setCapability(CapabilityType.PROXY, proxy);
        return new InternetExplorerDriver(cap);
    }

    public static WebDriver createDriver(BrowserChoice browserChoice, String proxyUrl, String downloadPath, String fileType) {
        if (browserChoice == null || BrowserChoice.FIREFOX.equals(browserChoice)) {
            return createFireFoxDriver(proxyUrl, downloadPath, fileType);
        } else if (BrowserChoice.IE.equals(browserChoice)) {
            return createInternetExplorerDriver(proxyUrl);
        } else {
            return ReflectionUtils.createInstanceOfType(browserChoice.getDriverClass(), true);
        }
    }
    protected static WebDriver createFireFoxDriver(String downloadPath, String fileType) {
        return createFireFoxDriver("", downloadPath, fileType);
    }


    @SuppressWarnings("deprecation")
    protected static WebDriver createFireFoxDriver(String proxyUrl, String downloadPath, String fileType) {
        FirefoxProfile profile = new FirefoxProfile();

        // this should disable the proxy popup on some pc's
        profile.setPreference("network.proxy.type", 4);

        // This should fix popups concerning secure connections.
        profile.setAssumeUntrustedCertificateIssuer(true);
        profile.setAcceptUntrustedCertificates(true);

        // This sets the proxy optionally
        if (!proxyUrl.isEmpty()) {
            profile.setPreference("network.proxy.type", 1);
            Proxy proxy = new Proxy();
            proxy.setHttpProxy(proxyUrl)
            .setFtpProxy(proxyUrl)
            .setSslProxy(proxyUrl)
            .setNoProxy("");
            profile.setProxyPreferences(proxy);
        }

        profile.setPreference(BROWSERMESSAGE, false);

        profile.setPreference("dom.ipc.plugins.java.enabled", false);
        profile.setPreference("security.checkloaduri", false);

        profile.setPreference("browser.ssl_override_behavior", 0);
        profile.setPreference("security.ssl.allow_unrestricted_renego_everywhere__temporarily_available_pref;", true);
        profile.setPreference(BROWSERMESSAGE, false);
        profile.setPreference("profile.secure_ssl", true);
        profile.setPreference(BROWSERMESSAGE, false);
        profile.setPreference("security.csp.enable", false);
        profile.setPreference("security.OCSP.enabled", 0);
        profile.setPreference("browser.download.manager.quitBehavior", 1);

        profile.setPreference("browser.download.manager.alertOnEXEOpen", false);
        profile.setPreference("browser.download.manager.quitBehavior", 1);

        profile.setPreference("browser.download.manager.alertOnEXEOpen", false);
        profile.setPreference("security.csp.enable", false);
        profile.setPreference("security.OCSP.enabled", 0);
        profile.setPreference("browser.download.manager.quitBehavior", 1);

        profile.setPreference(BROWSERMESSAGE, false);
        profile.setPreference("browser.ssl_override_behavior", 0);

        profile.setPreference("security.enable_tls", false);

        profile.setPreference("security.checkloaduri", false);

        if (!StringUtils.isEmpty(fileType) && !StringUtils.isEmpty(downloadPath)) {
            //download a file automatically
            profile.setPreference("browser.download.folderList",2);
            profile.setPreference("browser.download.manager.showWhenStarting",false);
            profile.setPreference("browser.download.dir", downloadPath);
            profile.setPreference("browser.helperApps.neverAsk.saveToDisk",fileType);
            profile.setPreference("browser.helperApps.neverAsk.openFile", fileType);
            profile.setPreference("browser.helperApps.alwaysAsk.force", false);
            profile.setPreference("plugin.disable_full_page_plugin_for_types", fileType);
            profile.setPreference("pdfjs.disabled", true);
        }

        FirefoxDriver firefoxDriver = null;
        FirefoxBinary binary = new FirefoxBinary();
        try {
            firefoxDriver = new FirefoxDriver(binary, profile);
        } catch (WebDriverException e) {
            /*
             * This is a bug in Selenium. When an exception is thrown when selenium tries to create 
             * to create a driver, than their is already a Firefox window open. This window needs to be closed.
             */
            
            binary.quit();
            //throw the exception again
            throw e;
        }
        return firefoxDriver;
    }

}
