package org.unitils.selenium.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * WebPage:
 * You can only add this annotation to a field. The field represents a webpage, 
 * this means that it contains the webelements of a webpage.
 * It uses the webdriver (field with {@link TestWebDriver}) to initialize the elements.
 * 
 * @author Jeroen Horemans
 * @author Thomas De Rycke
 * @author Willemijn Wouters
 * 
 * @since 1.0.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Target({ElementType.FIELD})
public @interface WebPage {
//empty
}
