/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.selenium;

import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.unitils.selenium.BrowserChoice;
import org.unitils.util.ReflectionUtils;

public class WebDriverFactory {
    private static final String BROWSERMESSAGE = "privacy.popups.showBrowserMessage";

    public static WebDriver createDriver(BrowserChoice browserChoice, String downloadPath, String fileType) {
        if (browserChoice == null || BrowserChoice.FIREFOX.equals((Object)browserChoice)) {
            return WebDriverFactory.createFireFoxDriver(downloadPath, fileType);
        }
        return (WebDriver)ReflectionUtils.createInstanceOfType(browserChoice.getDriverClass(), (boolean)true);
    }

    protected static WebDriver createInternetExplorerDriver(String proxyUrl) {
        Proxy proxy = new Proxy();
        proxy.setHttpProxy(proxyUrl).setFtpProxy(proxyUrl).setSslProxy(proxyUrl).setNoProxy("");
        DesiredCapabilities cap = new DesiredCapabilities();
        cap.setCapability("proxy", (Object)proxy);
        return new InternetExplorerDriver((Capabilities)cap);
    }

    public static WebDriver createDriver(BrowserChoice browserChoice, String proxyUrl, String downloadPath, String fileType) {
        if (browserChoice == null || BrowserChoice.FIREFOX.equals((Object)browserChoice)) {
            return WebDriverFactory.createFireFoxDriver(proxyUrl, downloadPath, fileType);
        }
        if (BrowserChoice.IE.equals((Object)browserChoice)) {
            return WebDriverFactory.createInternetExplorerDriver(proxyUrl);
        }
        return (WebDriver)ReflectionUtils.createInstanceOfType(browserChoice.getDriverClass(), (boolean)true);
    }

    protected static WebDriver createFireFoxDriver(String downloadPath, String fileType) {
        return WebDriverFactory.createFireFoxDriver("", downloadPath, fileType);
    }

    protected static WebDriver createFireFoxDriver(String proxyUrl, String downloadPath, String fileType) {
        FirefoxProfile profile = new FirefoxProfile();
        profile.setPreference("network.proxy.type", 4);
        profile.setAssumeUntrustedCertificateIssuer(true);
        profile.setAcceptUntrustedCertificates(true);
        profile.setPreference(BROWSERMESSAGE, false);
        profile.setPreference("dom.ipc.plugins.java.enabled", false);
        profile.setPreference("security.checkloaduri", false);
        profile.setPreference("browser.ssl_override_behavior", 0);
        profile.setPreference("security.ssl.allow_unrestricted_renego_everywhere__temporarily_available_pref;", true);
        profile.setPreference(BROWSERMESSAGE, false);
        profile.setPreference("profile.secure_ssl", true);
        profile.setPreference(BROWSERMESSAGE, false);
        profile.setPreference("security.csp.enable", false);
        profile.setPreference("security.OCSP.enabled", 0);
        profile.setPreference("browser.download.manager.quitBehavior", 1);
        profile.setPreference("browser.download.manager.alertOnEXEOpen", false);
        profile.setPreference("browser.download.manager.quitBehavior", 1);
        profile.setPreference("browser.download.manager.alertOnEXEOpen", false);
        profile.setPreference("security.csp.enable", false);
        profile.setPreference("security.OCSP.enabled", 0);
        profile.setPreference("browser.download.manager.quitBehavior", 1);
        profile.setPreference(BROWSERMESSAGE, false);
        profile.setPreference("browser.ssl_override_behavior", 0);
        profile.setPreference("security.enable_tls", false);
        profile.setPreference("security.checkloaduri", false);
        if (!StringUtils.isEmpty((String)fileType) && !StringUtils.isEmpty((String)downloadPath)) {
            profile.setPreference("browser.download.folderList", 2);
            profile.setPreference("browser.download.manager.showWhenStarting", false);
            profile.setPreference("browser.download.dir", downloadPath);
            profile.setPreference("browser.helperApps.neverAsk.saveToDisk", fileType);
            profile.setPreference("browser.helperApps.neverAsk.openFile", fileType);
            profile.setPreference("browser.helperApps.alwaysAsk.force", false);
            profile.setPreference("plugin.disable_full_page_plugin_for_types", fileType);
            profile.setPreference("pdfjs.disabled", true);
        }
        DesiredCapabilities capabilities = DesiredCapabilities.firefox();
        if (!proxyUrl.isEmpty()) {
            capabilities.setCapability("firefox_profile", (Object)profile);
            profile.setPreference("network.proxy.type", 1);
            Proxy proxy = new Proxy();
            proxy.setHttpProxy(proxyUrl).setFtpProxy(proxyUrl).setSslProxy(proxyUrl).setNoProxy("");
            capabilities.setCapability("proxy", (Object)proxy);
        }
        FirefoxDriver firefoxDriver = null;
        FirefoxBinary binary = new FirefoxBinary();
        try {
            firefoxDriver = new FirefoxDriver(binary, profile, (Capabilities)capabilities);
        }
        catch (WebDriverException e) {
            binary.quit();
            throw e;
        }
        return firefoxDriver;
    }
}

