/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.selenium;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.support.PageFactory;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.selenium.BrowserChoice;
import org.unitils.selenium.WebDriverFactory;
import org.unitils.selenium.annotation.BaseUrl;
import org.unitils.selenium.annotation.TestWebDriver;
import org.unitils.selenium.annotation.WebPage;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

public class WebDriverModule
implements Module {
    protected static final String PACKAGENAME = "org.unitils.selenium";
    protected static final String BROWSER_NAME_KEY = "org.unitils.selenium.browser.name";
    protected static final String BASE_URL_KEY = "org.unitils.selenium.baseUrl";
    protected static final String PROXY_HOST_KEY = "org.unitils.selenium.browser.proxy";
    protected static final String DOWNLOADPATH = "org.unitils.selenium.downloadpath";
    protected static final String FILETYPE = "org.unitils.selenium.filetype";
    protected static final String LIST_AUTOMATICALLY_DOWNLOAD = "application/pdf, application/vnd.fdf, application/x-msdos-program, application/x-unknown-application-octet-stream, application/vnd.ms-powerpoint, application/excel, application/vnd.ms-publisher, application/x-unknown-message-rfc822, application/vnd.ms-excel, application/msword, application/x-mspublisher, application/x-tar, application/zip, application/x-gzip,application/x-stuffit,application/vnd.ms-works, application/powerpoint, application/rtf, application/postscript, application/x-gtar, video/quicktime, video/x-msvideo, video/mpeg, audio/x-wav, audio/x-midi, audio/x-aiff, application/octet-stream";
    private BrowserChoice browserChoice;
    private String baseUrl;
    private String proxyUrl;
    private String downloadPath;
    private String fileType;
    private static final Log LOGGER = LogFactory.getLog(WebDriverModule.class);

    public void init(Properties configuration) {
        this.browserChoice = this.resolveBrowserChoice(configuration);
        this.baseUrl = this.resolveBaseUrl(configuration);
        this.proxyUrl = this.resolveProxyHost(configuration);
        LOGGER.debug((Object)"Driver Module loaded");
        this.downloadPath = PropertyUtils.getString((String)DOWNLOADPATH, (String)"", (Properties)configuration);
        this.fileType = PropertyUtils.getString((String)FILETYPE, (String)LIST_AUTOMATICALLY_DOWNLOAD, (Properties)configuration);
    }

    public void afterInit() {
    }

    private String resolveBaseUrl(Properties configuration) {
        String result = configuration.getProperty(BASE_URL_KEY);
        if (StringUtils.isEmpty((String)result)) {
            throw new IllegalArgumentException("plz fill in a value in the unitils.properties for org.unitils.selenium.baseUrl");
        }
        return result;
    }

    private BrowserChoice resolveBrowserChoice(Properties configuration) {
        String browserName = configuration.getProperty(BROWSER_NAME_KEY);
        if (StringUtils.isEmpty((String)browserName)) {
            LOGGER.info((Object)"org.unitils.selenium.browser.name not set. Will choose browser FIREFOX");
            return BrowserChoice.FIREFOX;
        }
        return BrowserChoice.valueOf(browserName);
    }

    private String resolveProxyHost(Properties configuration) {
        String result = configuration.getProperty(PROXY_HOST_KEY);
        if (StringUtils.isEmpty((String)result)) {
            LOGGER.info((Object)"org.unitils.selenium.browser.proxy not set. No proxy used");
            return "";
        }
        LOGGER.info((Object)("proxy: [" + result + "] set. Proxy used"));
        return result;
    }

    public void initWebDriver(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestWebDriver.class);
        if (fields.size() > 1) {
            StringBuilder builder = new StringBuilder();
            builder.append("There are more than one webdrivers.\n");
            for (Field field : fields) {
                builder.append("class: ");
                builder.append(field.getDeclaringClass().getName());
                builder.append(", field: ");
                builder.append(field.getName());
                builder.append("\n");
            }
            LOGGER.warn((Object)builder.toString());
        }
        for (Field field : fields) {
            WebDriver driver = this.proxyUrl.isEmpty() ? WebDriverFactory.createDriver(this.browserChoice, this.getAbsoluteDownloadPath(this.downloadPath), this.fileType) : WebDriverFactory.createDriver(this.browserChoice, this.proxyUrl, this.getAbsoluteDownloadPath(this.downloadPath), this.fileType);
            driver.manage().deleteAllCookies();
            ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)driver);
        }
    }

    protected String getAbsoluteDownloadPath(String path) {
        if (!StringUtils.isEmpty((String)path)) {
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            return file.getAbsolutePath();
        }
        return "";
    }

    protected void killWebDriver(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestWebDriver.class);
        for (Field field : fields) {
            WebDriver driver = (WebDriver)ReflectionUtils.getFieldValue((Object)testObject, (Field)field);
            LOGGER.debug((Object)("closing a driver that is on page : " + driver.getCurrentUrl()));
            driver.quit();
            this.nastyDoubleCheck(driver);
            this.nastyDoubleCheck(driver);
        }
    }

    private void nastyDoubleCheck(WebDriver driver) {
        try {
            Thread.sleep(500L);
            driver.getTitle();
            driver.close();
            driver.quit();
        }
        catch (WebDriverException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void initBaseUrl(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), BaseUrl.class);
        for (Field field : fields) {
            ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)this.baseUrl);
        }
    }

    public void initElements(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), WebPage.class);
        Set webdrivers = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestWebDriver.class);
        if (webdrivers.size() > 0) {
            WebDriver webdriver = (WebDriver)ReflectionUtils.getFieldValue((Object)testObject, (Field)((Field)webdrivers.iterator().next()));
            for (Field field : fields) {
                if (webdriver == null) continue;
                ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)this.getElement(webdriver, field.getType()));
            }
        } else {
            LOGGER.error((Object)"The TestWebDriver cannot be found.");
        }
    }

    protected Object getElement(WebDriver webdriver, Class<?> type) {
        return PageFactory.initElements((WebDriver)webdriver, type);
    }

    public TestListener getTestListener() {
        return new TestListener(){

            public void beforeTestSetUp(Object testObject, Method testMethod) {
                super.beforeTestSetUp(testObject, testMethod);
                WebDriverModule.this.initWebDriver(testObject);
                WebDriverModule.this.initBaseUrl(testObject);
                WebDriverModule.this.initElements(testObject);
            }

            public void afterTestTearDown(Object testObject, Method testMethod) {
                WebDriverModule.this.killWebDriver(testObject);
                super.afterTestTearDown(testObject, testMethod);
            }
        };
    }
}

