/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.selenium;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.unitils.core.Unitils;
import org.unitils.selenium.BrowserChoice;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

public class WebDriverFactory {
    private static final Log LOGGER = LogFactory.getLog(WebDriverFactory.class);
    private static final String BROWSERMESSAGE = "privacy.popups.showBrowserMessage";

    public static WebDriver createDriver(BrowserChoice browserChoice, String downloadPath, String fileType) {
        if (browserChoice == null || BrowserChoice.FIREFOX.equals((Object)browserChoice)) {
            return WebDriverFactory.createFireFoxDriver(downloadPath, fileType);
        }
        if (BrowserChoice.CHROME.equals((Object)browserChoice)) {
            return WebDriverFactory.createChromeDriver();
        }
        if (BrowserChoice.IE.equals((Object)browserChoice)) {
            DesiredCapabilities cap = DesiredCapabilities.internetExplorer();
            cap.setCapability("loggingPrefs", (Object)WebDriverFactory.createLoggingPreferences());
            return new InternetExplorerDriver((Capabilities)cap);
        }
        return (WebDriver)ReflectionUtils.createInstanceOfType(browserChoice.getDriverClass(), (boolean)true);
    }

    protected static LoggingPreferences createLoggingPreferences() {
        LoggingPreferences logPrefs = new LoggingPreferences();
        Properties unitilsProperties = WebDriverFactory.getUnitilsProperties();
        logPrefs.enable("performance", Level.parse(PropertyUtils.getString((String)"org.unitils.selenium.logging.performance", (String)"ALL", (Properties)unitilsProperties)));
        logPrefs.enable("browser", Level.parse(PropertyUtils.getString((String)"org.unitils.selenium.logging.browser", (String)"ALL", (Properties)unitilsProperties)));
        logPrefs.enable("client", Level.parse(PropertyUtils.getString((String)"org.unitils.selenium.logging.client", (String)"ALL", (Properties)unitilsProperties)));
        logPrefs.enable("driver", Level.parse(PropertyUtils.getString((String)"org.unitils.selenium.logging.driver", (String)"ALL", (Properties)unitilsProperties)));
        logPrefs.enable("profiler", Level.parse(PropertyUtils.getString((String)"org.unitils.selenium.logging.profiler", (String)"ALL", (Properties)unitilsProperties)));
        logPrefs.enable("server", Level.parse(PropertyUtils.getString((String)"org.unitils.selenium.logging.server", (String)"ALL", (Properties)unitilsProperties)));
        return logPrefs;
    }

    protected static WebDriver createChromeDriver() {
        DesiredCapabilities cap = DesiredCapabilities.chrome();
        cap.setCapability("loggingPrefs", (Object)WebDriverFactory.createLoggingPreferences());
        String filePathBinary = PropertyUtils.getString((String)"org.unitils.selenium.chromebinary", (String)"", (Properties)WebDriverFactory.getUnitilsProperties());
        if (!StringUtils.isEmpty((String)filePathBinary)) {
            ChromeOptions options = new ChromeOptions();
            File tempFileLocation = new File(filePathBinary);
            if (tempFileLocation.exists()) {
                options.setBinary(tempFileLocation.getAbsolutePath());
                cap.setCapability("chromeOptions", (Object)options);
            }
        }
        if (!StringUtils.isEmpty((String)PropertyUtils.getString((String)"org.unitils.selenium.logging.file", (String)"", (Properties)WebDriverFactory.getUnitilsProperties()))) {
            System.setProperty("webdriver.chrome.logfile", PropertyUtils.getString((String)"org.unitils.selenium.logging.file", (String)"", (Properties)WebDriverFactory.getUnitilsProperties()));
        }
        return new ChromeDriver((Capabilities)cap);
    }

    public static void setLogPropertiesIE() {
        String logLevel = PropertyUtils.getString((String)"org.unitils.selenium.logging.IE", (String)"FATAL", (Properties)WebDriverFactory.getUnitilsProperties());
        System.setProperty("webdriver.ie.driver.loglevel", logLevel);
        File fileFromProperty = WebDriverFactory.getFileFromProperty("org.unitils.selenium.logging.file");
        if (fileFromProperty != null) {
            System.setProperty("webdriver.ie.driver.logfile", fileFromProperty.getAbsolutePath());
        }
    }

    protected static WebDriver createInternetExplorerDriver(String proxyUrl) {
        Proxy proxy = new Proxy();
        proxy.setHttpProxy(proxyUrl).setFtpProxy(proxyUrl).setSslProxy(proxyUrl).setNoProxy("");
        DesiredCapabilities cap = DesiredCapabilities.internetExplorer();
        cap.setCapability("proxy", (Object)proxy);
        String logLevel = PropertyUtils.getString((String)"org.unitils.selenium.logging.IE", (String)"FATAL", (Properties)WebDriverFactory.getUnitilsProperties());
        cap.setCapability("logLevel", logLevel);
        WebDriverFactory.setLogPropertiesIE();
        return new InternetExplorerDriver((Capabilities)cap);
    }

    public static WebDriver createDriver(BrowserChoice browserChoice, String proxyUrl, String downloadPath, String fileType) {
        if (browserChoice == null || BrowserChoice.FIREFOX.equals((Object)browserChoice)) {
            return WebDriverFactory.createFireFoxDriver(proxyUrl, downloadPath, fileType);
        }
        if (BrowserChoice.IE.equals((Object)browserChoice)) {
            return WebDriverFactory.createInternetExplorerDriver(proxyUrl);
        }
        return (WebDriver)ReflectionUtils.createInstanceOfType(browserChoice.getDriverClass(), (boolean)true);
    }

    protected static WebDriver createFireFoxDriver(String downloadPath, String fileType) {
        return WebDriverFactory.createFireFoxDriver("", downloadPath, fileType);
    }

    protected static WebDriver createFireFoxDriver(String proxyUrl, String downloadPath, String fileType) {
        FirefoxProfile profile = new FirefoxProfile();
        profile.setPreference("network.proxy.type", 4);
        profile.setAssumeUntrustedCertificateIssuer(true);
        profile.setAcceptUntrustedCertificates(true);
        profile.setPreference(BROWSERMESSAGE, false);
        profile.setPreference("dom.ipc.plugins.java.enabled", false);
        profile.setPreference("security.checkloaduri", false);
        profile.setPreference("browser.ssl_override_behavior", 0);
        profile.setPreference("security.ssl.allow_unrestricted_renego_everywhere__temporarily_available_pref;", true);
        profile.setPreference(BROWSERMESSAGE, false);
        profile.setPreference("profile.secure_ssl", true);
        profile.setPreference(BROWSERMESSAGE, false);
        profile.setPreference("security.csp.enable", false);
        profile.setPreference("security.OCSP.enabled", 0);
        profile.setPreference("browser.download.manager.quitBehavior", 1);
        profile.setPreference("browser.download.manager.alertOnEXEOpen", false);
        profile.setPreference("browser.download.manager.quitBehavior", 1);
        profile.setPreference("browser.download.manager.alertOnEXEOpen", false);
        profile.setPreference("security.csp.enable", false);
        profile.setPreference("security.OCSP.enabled", 0);
        profile.setPreference("browser.download.manager.quitBehavior", 1);
        profile.setPreference(BROWSERMESSAGE, false);
        profile.setPreference("browser.ssl_override_behavior", 0);
        profile.setPreference("security.enable_tls", false);
        profile.setPreference("security.checkloaduri", false);
        if (!StringUtils.isEmpty((String)fileType) && !StringUtils.isEmpty((String)downloadPath)) {
            profile.setPreference("browser.download.folderList", 2);
            profile.setPreference("browser.download.manager.showWhenStarting", false);
            profile.setPreference("browser.download.dir", downloadPath);
            profile.setPreference("browser.helperApps.neverAsk.saveToDisk", fileType);
            profile.setPreference("browser.helperApps.neverAsk.openFile", fileType);
            profile.setPreference("browser.helperApps.alwaysAsk.force", false);
            profile.setPreference("plugin.disable_full_page_plugin_for_types", fileType);
            profile.setPreference("pdfjs.disabled", true);
        }
        DesiredCapabilities capabilities = DesiredCapabilities.firefox();
        if (!proxyUrl.isEmpty()) {
            capabilities.setCapability("firefox_profile", (Object)profile);
            profile.setPreference("network.proxy.type", 1);
            Proxy proxy = new Proxy();
            proxy.setHttpProxy(proxyUrl).setFtpProxy(proxyUrl).setSslProxy(proxyUrl).setNoProxy("");
            capabilities.setCapability("proxy", (Object)proxy);
        }
        capabilities.setCapability("loggingPrefs", (Object)WebDriverFactory.createLoggingPreferences());
        File fileFromProperty = WebDriverFactory.getFileFromProperty("org.unitils.selenium.logging.file");
        if (fileFromProperty != null) {
            String absPath = fileFromProperty.getAbsolutePath();
            profile.setPreference("webdriver.log.file", absPath);
            profile.setPreference("webdriver.log.browser.file", absPath);
            profile.setPreference("webdriver.log.driver.file", absPath);
            profile.setPreference("webdriver.log.profiler.file", absPath);
        }
        FirefoxDriver firefoxDriver = null;
        FirefoxBinary binary = new FirefoxBinary();
        try {
            firefoxDriver = new FirefoxDriver(binary, profile, (Capabilities)capabilities);
        }
        catch (WebDriverException e) {
            binary.quit();
            throw e;
        }
        return firefoxDriver;
    }

    protected static File getFileFromProperty(String property) {
        String str = PropertyUtils.getString((String)property, (String)"", (Properties)WebDriverFactory.getUnitilsProperties());
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        File file = new File(str);
        if (!file.exists()) {
            LOGGER.debug((Object)("The file for property " + property + " is created at location: " + file.getAbsolutePath()));
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error((Object)("Oops, something went wrong with creating " + file.getAbsolutePath() + "."));
                return null;
            }
        }
        return file;
    }

    protected static Properties getUnitilsProperties() {
        return Unitils.getInstance().getConfiguration();
    }
}

