package org.unitils.selenium;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;

/**
 *
 * BrowserChoice.
 *
 * @author Jeroen Horemans
 * @author Thomas De Rycke
 * @author Willemijn Wouters
 *
 * @since 1.0.0
 *
 */
public enum BrowserChoice {

    /***/
    FIREFOX(FirefoxDriver.class),
    /***/
    HTMLUNIT(HtmlUnitDriver.class),
    /***/
    IE(InternetExplorerDriver.class),
    /***/
    CHROME(ChromeDriver.class);

    private Class<? extends WebDriver> driverClass;

    /**
     * @param driverClass : should extend {@link WebDriver}.
     */
    private BrowserChoice(final Class<? extends WebDriver> driverClass) {
        this.driverClass = driverClass;
    }

    /**
     * Getter driverClass.
     *
     * @return {@link Class} : extends {@link WebDriver}.
     */
    public Class<? extends WebDriver> getDriverClass() {
        return driverClass;
    }

}
