/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.selenium;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.unitils.core.Unitils;
import org.unitils.util.PropertyUtils;

public class CapabilitiesFactory {
    protected static DesiredCapabilities createCapabilitesFirefox(String proxyUrl, FirefoxProfile profile) {
        DesiredCapabilities capabilities = DesiredCapabilities.firefox();
        if (!proxyUrl.isEmpty()) {
            capabilities.setCapability("firefox_profile", (Object)profile);
            profile.setPreference("network.proxy.type", 1);
            Proxy proxy = new Proxy();
            proxy.setHttpProxy(proxyUrl).setFtpProxy(proxyUrl).setSslProxy(proxyUrl).setNoProxy("");
            capabilities.setCapability("proxy", (Object)proxy);
        }
        capabilities.setCapability("loggingPrefs", (Object)CapabilitiesFactory.createLoggingPreferences());
        return capabilities;
    }

    protected static DesiredCapabilities createCapabilitiesIE(String proxyUrl) {
        DesiredCapabilities cap = DesiredCapabilities.internetExplorer();
        cap.setCapability("loggingPrefs", (Object)CapabilitiesFactory.createLoggingPreferences());
        cap.setCapability("ignoreProtectedModeSettings", true);
        cap.setCapability("ignoreZoomSetting", true);
        if (StringUtils.isNotEmpty((String)proxyUrl)) {
            Proxy proxy = new Proxy();
            proxy.setHttpProxy(proxyUrl).setFtpProxy(proxyUrl).setSslProxy(proxyUrl).setNoProxy("");
            cap.setCapability("proxy", (Object)proxy);
        }
        return cap;
    }

    protected static DesiredCapabilities createCapabilitiesChrome() {
        DesiredCapabilities cap = DesiredCapabilities.chrome();
        cap.setCapability("loggingPrefs", (Object)CapabilitiesFactory.createLoggingPreferences());
        String filePathBinary = PropertyUtils.getString((String)"org.unitils.selenium.chromebinary", (String)"", (Properties)CapabilitiesFactory.getUnitilsProperties());
        if (!StringUtils.isEmpty((String)filePathBinary)) {
            ChromeOptions options = new ChromeOptions();
            File tempFileLocation = new File(filePathBinary);
            if (tempFileLocation.exists()) {
                options.setBinary(tempFileLocation.getAbsolutePath());
                cap.setCapability("chromeOptions", (Object)options);
            }
        }
        return cap;
    }

    protected static LoggingPreferences createLoggingPreferences() {
        LoggingPreferences logPrefs = new LoggingPreferences();
        Properties unitilsProperties = CapabilitiesFactory.getUnitilsProperties();
        logPrefs.enable("performance", Level.parse(PropertyUtils.getString((String)"org.unitils.selenium.logging.performance", (String)"ALL", (Properties)unitilsProperties)));
        logPrefs.enable("browser", Level.parse(PropertyUtils.getString((String)"org.unitils.selenium.logging.browser", (String)"ALL", (Properties)unitilsProperties)));
        logPrefs.enable("client", Level.parse(PropertyUtils.getString((String)"org.unitils.selenium.logging.client", (String)"ALL", (Properties)unitilsProperties)));
        logPrefs.enable("driver", Level.parse(PropertyUtils.getString((String)"org.unitils.selenium.logging.driver", (String)"ALL", (Properties)unitilsProperties)));
        logPrefs.enable("profiler", Level.parse(PropertyUtils.getString((String)"org.unitils.selenium.logging.profiler", (String)"ALL", (Properties)unitilsProperties)));
        logPrefs.enable("server", Level.parse(PropertyUtils.getString((String)"org.unitils.selenium.logging.server", (String)"ALL", (Properties)unitilsProperties)));
        return logPrefs;
    }

    private static Properties getUnitilsProperties() {
        return Unitils.getInstance().getConfiguration();
    }
}

