/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.selenium;

import com.google.common.base.Supplier;
import com.thoughtworks.selenium.webdriven.WebDriverBackedSelenium;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.unitils.testlink.annotation.TestLink;

public class ScreenshotTakingWebDriver
extends WebDriverBackedSelenium {
    private static final Log LOGGER = LogFactory.getLog(ScreenshotTakingWebDriver.class);
    private int sequenceNr;

    public ScreenshotTakingWebDriver(Supplier<WebDriver> maker, String baseUrl) {
        super(maker, baseUrl);
    }

    public ScreenshotTakingWebDriver(WebDriver baseDriver, String baseUrl) {
        super(baseDriver, baseUrl);
    }

    public void saveScreenshot() {
        StringBuilder seqNr = new StringBuilder("" + this.sequenceNr);
        while (seqNr.length() < 3) {
            seqNr.insert(0, "0");
        }
        this.saveScreenshot("screenshot_" + seqNr.toString());
        ++this.sequenceNr;
    }

    public void saveScreenshot(String fileName) {
        File screenshotDir = new File("./target/screenshot");
        if (!screenshotDir.exists()) {
            screenshotDir.mkdir();
        }
        StackTraceElement[] st = new Throwable().getStackTrace();
        for (int i = 1; i < st.length; ++i) {
            String className = st[i].getClassName();
            String methodName = st[i].getMethodName();
            try {
                Class<?> clazz = Class.forName(className);
                Method method = clazz.getMethod(methodName, new Class[0]);
                if (method.getAnnotation(Test.class) == null) continue;
                if (method.getAnnotation(TestLink.class) != null) {
                    screenshotDir = new File(screenshotDir, method.getAnnotation(TestLink.class).value());
                    break;
                }
                screenshotDir = new File(screenshotDir, methodName);
                break;
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.saveScreenshot(screenshotDir, fileName);
    }

    public void saveScreenshot(File screenshotDir, String fileName) {
        File scrFile = (File)((TakesScreenshot)this.getWrappedDriver()).getScreenshotAs(OutputType.FILE);
        try {
            FileUtils.copyFile((File)scrFile, (File)new File(screenshotDir, fileName + ".png"));
            scrFile.deleteOnExit();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void clickWithScreenshot(String locator) {
        this.saveScreenshot();
        super.click(locator);
    }

    public void clickWithScreenshotAt(String locator, String coordString) {
        this.saveScreenshot();
        super.clickAt(locator, coordString);
    }

    public void waitForPageToLoad(String timeout) {
        super.waitForPageToLoad(timeout);
        this.saveScreenshot();
    }

    public void waitForFrameToLoad(String frameAddress, String timeout) {
        super.waitForFrameToLoad(frameAddress, timeout);
        this.saveScreenshot();
    }
}

