/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.selenium;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.unitils.core.Unitils;
import org.unitils.core.UnitilsException;
import org.unitils.selenium.BrowserChoice;
import org.unitils.selenium.CapabilitiesChoice;
import org.unitils.selenium.CapabilitiesFactory;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

public class WebDriverFactory {
    private static final Log LOGGER = LogFactory.getLog(WebDriverFactory.class);
    private static final String BROWSERMESSAGE = "privacy.popups.showBrowserMessage";

    public static WebDriver createDriver(BrowserChoice browserChoice, String downloadPath, String fileType) {
        if (browserChoice == null || BrowserChoice.FIREFOX.equals((Object)browserChoice)) {
            return WebDriverFactory.createFireFoxDriver(downloadPath, fileType);
        }
        if (BrowserChoice.CHROME.equals((Object)browserChoice)) {
            return WebDriverFactory.createChromeDriver();
        }
        if (BrowserChoice.IE.equals((Object)browserChoice)) {
            return new InternetExplorerDriver((Capabilities)CapabilitiesFactory.createCapabilitiesIE(""));
        }
        if (BrowserChoice.REMOTE.equals((Object)browserChoice)) {
            return WebDriverFactory.createRemoteWebdriver("", fileType, downloadPath);
        }
        return (WebDriver)ReflectionUtils.createInstanceOfType(browserChoice.getDriverClass(), (boolean)true);
    }

    protected static WebDriver createChromeDriver() {
        if (!StringUtils.isEmpty((String)PropertyUtils.getString((String)"org.unitils.selenium.logging.file", (String)"", (Properties)WebDriverFactory.getUnitilsProperties()))) {
            System.setProperty("webdriver.chrome.logfile", PropertyUtils.getString((String)"org.unitils.selenium.logging.file", (String)"", (Properties)WebDriverFactory.getUnitilsProperties()));
        }
        return new ChromeDriver((Capabilities)CapabilitiesFactory.createCapabilitiesChrome());
    }

    public static void setLogPropertiesIE() {
        String logLevel = PropertyUtils.getString((String)"org.unitils.selenium.logging.IE", (String)"FATAL", (Properties)WebDriverFactory.getUnitilsProperties());
        System.setProperty("webdriver.ie.driver.loglevel", logLevel);
        File fileFromProperty = WebDriverFactory.getFileFromProperty("org.unitils.selenium.logging.file");
        if (fileFromProperty != null) {
            System.setProperty("webdriver.ie.driver.logfile", fileFromProperty.getAbsolutePath());
        }
    }

    protected static WebDriver createInternetExplorerDriver(String proxyUrl) {
        return new InternetExplorerDriver((Capabilities)CapabilitiesFactory.createCapabilitiesIE(proxyUrl));
    }

    public static WebDriver createDriver(BrowserChoice browserChoice, String proxyUrl, String downloadPath, String fileType) {
        if (browserChoice == null || BrowserChoice.FIREFOX.equals((Object)browserChoice)) {
            return WebDriverFactory.createFireFoxDriver(proxyUrl, downloadPath, fileType);
        }
        if (BrowserChoice.IE.equals((Object)browserChoice)) {
            return WebDriverFactory.createInternetExplorerDriver(proxyUrl);
        }
        if (BrowserChoice.REMOTE.equals((Object)browserChoice)) {
            return WebDriverFactory.createRemoteWebdriver(proxyUrl, fileType, downloadPath);
        }
        return (WebDriver)ReflectionUtils.createInstanceOfType(browserChoice.getDriverClass(), (boolean)true);
    }

    protected static WebDriver createFireFoxDriver(String downloadPath, String fileType) {
        return WebDriverFactory.createFireFoxDriver("", downloadPath, fileType);
    }

    protected static WebDriver createFireFoxDriver(String proxyUrl, String downloadPath, String fileType) {
        FirefoxDriver firefoxDriver = null;
        FirefoxBinary binary = new FirefoxBinary();
        FirefoxProfile profile = WebDriverFactory.createFirefoxProfile(fileType, downloadPath);
        try {
            firefoxDriver = new FirefoxDriver(binary, profile, (Capabilities)CapabilitiesFactory.createCapabilitesFirefox(proxyUrl, profile));
        }
        catch (WebDriverException e) {
            binary.quit();
            throw e;
        }
        return firefoxDriver;
    }

    protected static FirefoxProfile createFirefoxProfile(String fileType, String downloadPath) {
        File fileFromProperty;
        FirefoxProfile profile = new FirefoxProfile();
        profile.setPreference("network.proxy.type", 4);
        profile.setAssumeUntrustedCertificateIssuer(true);
        profile.setAcceptUntrustedCertificates(true);
        profile.setPreference(BROWSERMESSAGE, false);
        profile.setPreference("dom.ipc.plugins.java.enabled", false);
        profile.setPreference("security.checkloaduri", false);
        profile.setPreference("browser.ssl_override_behavior", 0);
        profile.setPreference("security.ssl.allow_unrestricted_renego_everywhere__temporarily_available_pref;", true);
        profile.setPreference(BROWSERMESSAGE, false);
        profile.setPreference("profile.secure_ssl", true);
        profile.setPreference(BROWSERMESSAGE, false);
        profile.setPreference("security.csp.enable", false);
        profile.setPreference("security.OCSP.enabled", 0);
        profile.setPreference("browser.download.manager.quitBehavior", 1);
        profile.setPreference("browser.download.manager.alertOnEXEOpen", false);
        profile.setPreference("browser.download.manager.quitBehavior", 1);
        profile.setPreference("browser.download.manager.alertOnEXEOpen", false);
        profile.setPreference("security.csp.enable", false);
        profile.setPreference("security.OCSP.enabled", 0);
        profile.setPreference("browser.download.manager.quitBehavior", 1);
        profile.setPreference(BROWSERMESSAGE, false);
        profile.setPreference("browser.ssl_override_behavior", 0);
        profile.setPreference("security.enable_tls", false);
        profile.setPreference("security.checkloaduri", false);
        if (!StringUtils.isEmpty((String)fileType) && !StringUtils.isEmpty((String)downloadPath)) {
            profile.setPreference("browser.download.folderList", 2);
            profile.setPreference("browser.download.manager.showWhenStarting", false);
            profile.setPreference("browser.download.dir", downloadPath);
            profile.setPreference("browser.helperApps.neverAsk.saveToDisk", fileType);
            profile.setPreference("browser.helperApps.neverAsk.openFile", fileType);
            profile.setPreference("browser.helperApps.alwaysAsk.force", false);
            profile.setPreference("plugin.disable_full_page_plugin_for_types", fileType);
            profile.setPreference("pdfjs.disabled", true);
        }
        if ((fileFromProperty = WebDriverFactory.getFileFromProperty("org.unitils.selenium.logging.file")) != null) {
            String absPath = fileFromProperty.getAbsolutePath();
            profile.setPreference("webdriver.log.file", absPath);
            profile.setPreference("webdriver.log.browser.file", absPath);
            profile.setPreference("webdriver.log.driver.file", absPath);
            profile.setPreference("webdriver.log.profiler.file", absPath);
        }
        return profile;
    }

    protected static WebDriver createRemoteWebdriver(String proxyUrl, String fileType, String downloadPath) {
        URL remoteUrl;
        DesiredCapabilities capabilities = null;
        CapabilitiesChoice choice = WebDriverFactory.getChosenCapabilities();
        switch (choice) {
            case CHROME: {
                capabilities = CapabilitiesFactory.createCapabilitiesChrome();
                break;
            }
            case FIREFOX: {
                capabilities = CapabilitiesFactory.createCapabilitesFirefox(proxyUrl, WebDriverFactory.createFirefoxProfile(fileType, downloadPath));
                break;
            }
            case IE: {
                capabilities = CapabilitiesFactory.createCapabilitiesIE(proxyUrl);
            }
        }
        try {
            String urlProp = PropertyUtils.getString((String)"org.unitils.selenium.remotedriver.url", (String)"", (Properties)WebDriverFactory.getUnitilsProperties());
            if (StringUtils.isBlank((String)urlProp)) {
                return new RemoteWebDriver((Capabilities)capabilities);
            }
            remoteUrl = new URL(urlProp);
        }
        catch (MalformedURLException e) {
            throw new UnitilsException("The following URL is not valid.", (Throwable)e);
        }
        return new RemoteWebDriver(remoteUrl, (Capabilities)capabilities);
    }

    protected static CapabilitiesChoice getChosenCapabilities() {
        String chosenCapability = PropertyUtils.getString((String)"org.unitils.selenium.remotedriver.capabilities", (String)"", (Properties)WebDriverFactory.getUnitilsProperties());
        if (StringUtils.isBlank((String)chosenCapability)) {
            return CapabilitiesChoice.FIREFOX;
        }
        return CapabilitiesChoice.valueOf(chosenCapability);
    }

    protected static File getFileFromProperty(String property) {
        String str = PropertyUtils.getString((String)property, (String)"", (Properties)WebDriverFactory.getUnitilsProperties());
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        File file = new File(str);
        if (!file.exists()) {
            LOGGER.debug((Object)("The file for property " + property + " is created at location: " + file.getAbsolutePath()));
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error((Object)("Oops, something went wrong with creating " + file.getAbsolutePath() + "."));
                return null;
            }
        }
        return file;
    }

    protected static Properties getUnitilsProperties() {
        return Unitils.getInstance().getConfiguration();
    }
}

