/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.selenium;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.support.PageFactory;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.core.UnitilsException;
import org.unitils.dbmaintainer.locator.ClassPathDataLocator;
import org.unitils.selenium.BrowserChoice;
import org.unitils.selenium.ScreenshotTakingWebDriver;
import org.unitils.selenium.WebDriverFactory;
import org.unitils.selenium.annotation.BaseUrl;
import org.unitils.selenium.annotation.TestWebDriver;
import org.unitils.selenium.annotation.WebPage;
import org.unitils.util.AnnotationUtils;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

public class WebDriverModule
implements Module {
    protected static final String PACKAGENAME = "org.unitils.selenium";
    public static final String BROWSER_NAME_KEY = "org.unitils.selenium.browser.name";
    public static final String REMOTE_CAPABILITIES = "org.unitils.selenium.remotedriver.capabilities";
    public static final String BASE_URL_KEY = "org.unitils.selenium.baseUrl";
    public static final String REMOTE_URL_KEY = "org.unitils.selenium.remotedriver.url";
    public static final String PROXY_HOST_KEY = "org.unitils.selenium.browser.proxy";
    public static final String DOWNLOADPATH = "org.unitils.selenium.downloadpath";
    public static final String FILETYPE = "org.unitils.selenium.filetype";
    public static final String LIST_AUTOMATICALLY_DOWNLOAD = "application/pdf, application/vnd.fdf, application/x-msdos-program, application/x-unknown-application-octet-stream, application/vnd.ms-powerpoint, application/excel, application/vnd.ms-publisher, application/x-unknown-message-rfc822, application/vnd.ms-excel, application/msword, application/x-mspublisher, application/x-tar, application/zip, application/x-gzip,application/x-stuffit,application/vnd.ms-works, application/powerpoint, application/rtf, application/postscript, application/x-gtar, video/quicktime, video/x-msvideo, video/mpeg, audio/x-wav, audio/x-midi, audio/x-aiff, application/octet-stream";
    public static final String FIREFOX_BINARY_KEY = "org.unitils.selenium.firefoxbinary";
    public static final String IE_BINARY_KEY = "org.unitils.selenium.iebinary";
    public static final String CHROME_DRIVER_KEY = "org.unitils.selenium.chromedriver";
    public static final String CHROME_BINARY_KEY = "org.unitils.selenium.chromebinary";
    public static final String LOGGINGPROP_CONSOLE_ENABLED = "org.unitils.selenium.logging.console.enabled";
    public static final String LOGGINGPROP_PERFORMANCE = "org.unitils.selenium.logging.performance";
    public static final String LOGGINGPROP_BROWSER = "org.unitils.selenium.logging.browser";
    public static final String LOGGINGPROP_CLIENT = "org.unitils.selenium.logging.client";
    public static final String LOGGINGPROP_DRIVER = "org.unitils.selenium.logging.driver";
    public static final String LOGGINGPROP_PROFILER = "org.unitils.selenium.logging.profiler";
    public static final String LOGGINGPROP_SERVER = "org.unitils.selenium.logging.server";
    public static final String LOGGING_FILE_PROP = "org.unitils.selenium.logging.file";
    public static final String LOGGINGPROP_IE = "org.unitils.selenium.logging.IE";
    private BrowserChoice browserChoice;
    private String baseUrl;
    private String proxyUrl;
    private String downloadPath;
    private String fileType;
    private Properties configuration;
    private static final Log LOGGER = LogFactory.getLog(WebDriverModule.class);
    private ClassPathDataLocator dataLocator;
    public static final String TARGETSUREFIREREPORTS = "target/surefire-reports/";

    public void init(Properties configuration) {
        this.dataLocator = new ClassPathDataLocator();
        this.browserChoice = this.resolveBrowserChoice(configuration);
        this.baseUrl = this.resolveBaseUrl(configuration);
        this.proxyUrl = this.resolveProxyHost(configuration);
        LOGGER.debug((Object)"Driver Module loaded");
        this.downloadPath = PropertyUtils.getString((String)DOWNLOADPATH, (String)"", (Properties)configuration);
        this.fileType = PropertyUtils.getString((String)FILETYPE, (String)LIST_AUTOMATICALLY_DOWNLOAD, (Properties)configuration);
        this.configuration = configuration;
        String bit = System.getProperty("sun.arch.data.model");
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.checkFirefoxDriver();
        this.checkChromeDriver(bit, classLoader);
        this.checkIEDriver(bit, classLoader);
    }

    public void afterInit() {
    }

    private String resolveBaseUrl(Properties configuration) {
        String result = configuration.getProperty(BASE_URL_KEY);
        if (StringUtils.isEmpty((String)result)) {
            throw new IllegalArgumentException("plz fill in a value in the unitils.properties for org.unitils.selenium.baseUrl");
        }
        return result;
    }

    private BrowserChoice resolveBrowserChoice(Properties configuration) {
        String browserName = configuration.getProperty(BROWSER_NAME_KEY);
        if (StringUtils.isEmpty((String)browserName)) {
            LOGGER.info((Object)"org.unitils.selenium.browser.name not set. Will choose browser FIREFOX");
            return BrowserChoice.FIREFOX;
        }
        return BrowserChoice.valueOf(browserName);
    }

    private String resolveProxyHost(Properties configuration) {
        String result = configuration.getProperty(PROXY_HOST_KEY);
        if (StringUtils.isEmpty((String)result)) {
            LOGGER.info((Object)"org.unitils.selenium.browser.proxy not set. No proxy used");
            return "";
        }
        LOGGER.info((Object)("proxy: [" + result + "] set. Proxy used"));
        return result;
    }

    public void initWebDriver(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestWebDriver.class);
        if (fields.size() > 1) {
            StringBuilder builder = new StringBuilder();
            builder.append("There are more than one webdrivers.\n");
            for (Field field : fields) {
                builder.append("class: ");
                builder.append(field.getDeclaringClass().getName());
                builder.append(", field: ");
                builder.append(field.getName());
                builder.append("\n");
            }
            LOGGER.warn((Object)builder.toString());
        }
        for (Field field : fields) {
            WebDriver driver = this.proxyUrl.isEmpty() ? WebDriverFactory.createDriver(this.browserChoice, WebDriverModule.getAbsoluteDownloadPath(this.downloadPath), this.fileType) : WebDriverFactory.createDriver(this.browserChoice, this.proxyUrl, WebDriverModule.getAbsoluteDownloadPath(this.downloadPath), this.fileType);
            driver.manage().deleteAllCookies();
            ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)driver);
        }
    }

    protected static String getAbsoluteDownloadPath(String path) {
        if (!StringUtils.isEmpty((String)path)) {
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            return file.getAbsolutePath();
        }
        return "";
    }

    protected void killWebDriver(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestWebDriver.class);
        for (Field field : fields) {
            WebDriver driver = (WebDriver)ReflectionUtils.getFieldValue((Object)testObject, (Field)field);
            LOGGER.debug((Object)("closing a driver that is on page : " + driver.getCurrentUrl()));
            driver.close();
            driver.quit();
            this.nastyDoubleCheck(driver);
            this.nastyDoubleCheck(driver);
        }
    }

    private void nastyDoubleCheck(WebDriver driver) {
        try {
            Thread.sleep(500L);
            driver.getTitle();
            driver.close();
            driver.quit();
        }
        catch (WebDriverException e) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void initBaseUrl(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), BaseUrl.class);
        for (Field field : fields) {
            ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)this.baseUrl);
        }
    }

    public void initElements(Object testObject) {
        Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), WebPage.class);
        Set webdrivers = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestWebDriver.class);
        if (!webdrivers.isEmpty()) {
            WebDriver webdriver = (WebDriver)ReflectionUtils.getFieldValue((Object)testObject, (Field)((Field)webdrivers.iterator().next()));
            for (Field field : fields) {
                if (webdriver == null) continue;
                ReflectionUtils.setFieldValue((Object)testObject, (Field)field, (Object)this.getElement(webdriver, field.getType()));
            }
        } else {
            LOGGER.error((Object)"The TestWebDriver cannot be found.");
        }
    }

    protected void checkChromeDriver(String bit, ClassLoader classLoader) {
        String driver = "chrome driver";
        String pathChrome = "webdriver.chrome.driver";
        String absPath = "";
        if (!this.checkIfDriverIsAlreadyInSystem(System.getProperty(pathChrome), driver, pathChrome) && !this.checkIfDriverPropertyExistsInUnitilsProperties(CHROME_DRIVER_KEY, driver, pathChrome)) {
            if (SystemUtils.IS_OS_WINDOWS) {
                absPath = this.copyDriverIntoNewTempFile((URL)this.dataLocator.loadResources("chromedriver_win.exe", Boolean.valueOf(true)).get(0), "chromedriver_win.exe");
                System.setProperty(pathChrome, absPath);
            } else if (SystemUtils.IS_OS_MAC) {
                absPath = this.copyDriverIntoNewTempFile((URL)this.dataLocator.loadResources("chromedriver_mac32", Boolean.valueOf(true)).get(0), "chromedriver_mac32");
                System.setProperty(pathChrome, absPath);
            } else if (SystemUtils.IS_OS_LINUX) {
                absPath = this.copyDriverIntoNewTempFile((URL)this.dataLocator.loadResources("chromedriver_linux32", Boolean.valueOf(true)).get(0), "chromedriver_linux32");
                System.setProperty(pathChrome, absPath);
            }
            LOGGER.info((Object)WebDriverModule.createLogNewDriver(pathChrome, absPath));
        }
    }

    protected void checkFirefoxDriver() {
        String driver = "firefox driver";
        String pathFirefox = "webdriver.firefox.bin";
        if (!this.checkIfDriverIsAlreadyInSystem(System.getProperty(pathFirefox), driver, pathFirefox) && !this.checkIfDriverPropertyExistsInUnitilsProperties(FIREFOX_BINARY_KEY, driver, pathFirefox)) {
            LOGGER.error((Object)"There is no firefox driver found.");
        }
    }

    protected void checkIEDriver(String bit, ClassLoader classLoader) {
        String pathIE = "webdriver.ie.driver";
        String driver = "IE driver";
        String absPath = "";
        if (SystemUtils.IS_OS_WINDOWS && !this.checkIfDriverIsAlreadyInSystem(System.getProperty(pathIE), driver, pathIE) && !this.checkIfDriverPropertyExistsInUnitilsProperties(IE_BINARY_KEY, driver, pathIE)) {
            if (bit.equals("32")) {
                absPath = this.copyDriverIntoNewTempFile((URL)this.dataLocator.loadResources("IEDriverServer.exe", Boolean.valueOf(true)).get(0), "IEDriverServer.exe");
                System.setProperty(pathIE, absPath);
            } else if (bit.equals("64")) {
                absPath = this.copyDriverIntoNewTempFile((URL)this.dataLocator.loadResources("IEDriverServer_x64.exe", Boolean.valueOf(true)).get(0), "IEDriverServer_x64.exe");
                System.setProperty(pathIE, absPath);
            }
            LOGGER.info((Object)WebDriverModule.createLogNewDriver(pathIE, absPath));
        }
    }

    public boolean checkIfDriverIsAlreadyInSystem(String systemProp, String driver, String systemVarDriver) {
        if (!StringUtils.isEmpty((String)systemProp) && new File(systemProp).exists()) {
            StringBuilder builder = new StringBuilder().append("The ").append(driver).append(" already defined in the system (").append(systemVarDriver).append(") exists and will be used by Unitils. location:").append(systemProp);
            LOGGER.info((Object)builder);
            return true;
        }
        return false;
    }

    public boolean checkIfDriverPropertyExistsInUnitilsProperties(String key, String driver, String systemKey) {
        String unitilsDriver = PropertyUtils.getString((String)key, (String)"", (Properties)this.configuration);
        if (this.configuration.containsKey(key) && !StringUtils.isEmpty((String)unitilsDriver)) {
            File driverFile = new File(unitilsDriver);
            if (driverFile.exists()) {
                StringBuilder builder = new StringBuilder().append("The WebdriverModule uses the ").append(driver).append(" from the unitils.properties. location: ").append(driverFile.toString());
                LOGGER.info((Object)builder.toString());
                System.setProperty(systemKey, driverFile.getAbsolutePath());
                return true;
            }
            StringBuilder builder = new StringBuilder().append("The location of the ").append(driver).append(" defined in the unitils.properties does not exists. location: ").append(driverFile.getAbsolutePath());
            LOGGER.error((Object)builder.toString());
        }
        return false;
    }

    public String copyDriverIntoNewTempFile(URL url, String name) {
        StringBuilder result = new StringBuilder(TARGETSUREFIREREPORTS).append(name);
        File destination = new File(result.toString());
        try {
            FileUtils.copyInputStreamToFile((InputStream)url.openStream(), (File)destination);
            destination.setExecutable(true);
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new UnitilsException("Unitils couldn't launch a new webdriver! Check your taskmanager if the driver is still active.", (Throwable)e);
        }
        return destination.getAbsolutePath();
    }

    protected Object getElement(WebDriver webdriver, Class<?> type) {
        Object webpage = PageFactory.initElements((WebDriver)webdriver, type);
        for (Field field : AnnotationUtils.getFieldsAnnotatedWith(type, TestWebDriver.class)) {
            ReflectionUtils.setFieldValue((Object)webpage, (Field)field, (Object)webdriver);
        }
        this.initBaseUrl(webpage);
        return webpage;
    }

    public TestListener getTestListener() {
        return new WebdriverTestlistener();
    }

    protected static String createLogNewDriver(String systemVarDriver, String absPath) {
        return "The location of the variable defined in the ' " + systemVarDriver + "' didn't exist, so we have changed the location of the variable to the driver added in unitils.selenium. location: " + absPath;
    }

    public class WebdriverTestlistener
    extends TestListener {
        public void beforeTestSetUp(Object testObject, Method testMethod) {
            super.beforeTestSetUp(testObject, testMethod);
            WebDriverModule.this.initWebDriver(testObject);
            WebDriverModule.this.initBaseUrl(testObject);
            WebDriverModule.this.initElements(testObject);
        }

        public void afterTestMethod(Object testObject, Method testMethod, Throwable testThrowable) {
            if (PropertyUtils.getBoolean((String)WebDriverModule.LOGGINGPROP_CONSOLE_ENABLED, (boolean)false, (Properties)WebDriverModule.this.configuration)) {
                LOGGER.info((Object)("BEGIN CONSOLE TEST: " + testMethod.getName()));
                if (!WebDriverModule.this.resolveBrowserChoice(WebDriverModule.this.configuration).equals((Object)BrowserChoice.IE)) {
                    for (Field webdriverField : AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestWebDriver.class)) {
                        WebDriver webdriver = (WebDriver)ReflectionUtils.getFieldValue((Object)testObject, (Field)webdriverField);
                        for (String type : webdriver.manage().logs().getAvailableLogTypes()) {
                            try {
                                List entries = webdriver.manage().logs().get(type).getAll();
                                System.out.println(entries.size() + " " + type + " log entries found");
                                for (LogEntry entry : entries) {
                                    if (entry.getLevel().equals(Level.OFF)) continue;
                                    SimpleDateFormat format = new SimpleDateFormat("YYMMddHHmmss");
                                    System.out.println(format.format(new Date(entry.getTimestamp())) + " " + entry.getLevel() + " " + entry.getMessage());
                                }
                            }
                            catch (Exception e) {
                                LOGGER.debug((Object)("Log " + type + " is not available."));
                            }
                        }
                    }
                }
                LOGGER.info((Object)("END CONSOLE TEST: " + testMethod.getName()));
            }
            if (testThrowable != null) {
                int i = 0;
                try {
                    Set fields = AnnotationUtils.getFieldsAnnotatedWith(testObject.getClass(), TestWebDriver.class);
                    for (Field field : fields) {
                        WebDriver driver = (WebDriver)ReflectionUtils.getFieldValue((Object)testObject, (Field)field);
                        File surefire = new File(WebDriverModule.TARGETSUREFIREREPORTS);
                        if (!surefire.exists()) {
                            surefire.mkdir();
                        }
                        StringBuilder builder = new StringBuilder().append(testObject.getClass().getSimpleName()).append("-").append(testMethod.getName()).append("-").append(field.getName()).append("-").append(++i);
                        new ScreenshotTakingWebDriver(driver, WebDriverModule.this.baseUrl).saveScreenshot(surefire, builder.toString());
                        LOGGER.error((Object)("Something went wrong on this page: " + driver.getPageSource()));
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"The taking of the screenshot has made a terrible mistake! but we'll continue!", (Throwable)e);
                }
            }
        }

        public void afterTestTearDown(Object testObject, Method testMethod) {
            WebDriverModule.this.killWebDriver(testObject);
            super.afterTestTearDown(testObject, testMethod);
        }
    }
}

