/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.selenium.downloader.impl;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.openqa.selenium.WebElement;
import org.unitils.selenium.downloader.RobotDownloader;

public abstract class AbstractRobotDownloader
implements RobotDownloader {
    private static final Log LOGGER = LogFactory.getLog(AbstractRobotDownloader.class);

    @Override
    public File getDownloadFolder() {
        return new File(System.getenv("USERPROFILE") + File.separator + "Downloads");
    }

    @Override
    public void checkIfDownloadedFileExists(WebElement element) {
        this.checkIfDownloadedFileExists(this.getDownloadedFile(element));
    }

    @Override
    public void checkIfDownloadedFileExists(String file) {
        this.checkIfDownloadedFileExists(new File(this.getDownloadFolder(), file));
    }

    public void checkIfDownloadedFileExists(File expectedFile) {
        if (!expectedFile.exists()) {
            Assert.fail((String)("The file should be downloaded in the Downloads folder of your user profile, but it cannot be found. The name of the file should be: " + expectedFile.getAbsolutePath()));
        }
    }

    @Override
    public boolean deleteDownloadedFile(WebElement element) {
        return this.deleteDownloadedFile(this.getDownloadedFile(element));
    }

    protected boolean deleteDownloadedFile(File expectedFile) {
        if (expectedFile.exists()) {
            expectedFile.delete();
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteDownloadedFile(String fileName) {
        return this.deleteDownloadedFile(new File(this.getDownloadFolder(), fileName));
    }

    @Override
    public File getDownloadedFile(WebElement element) {
        String location = this.getAttributesLocationFromElement(element);
        String filename = location.substring(location.lastIndexOf("/") + 1);
        return new File(this.getDownloadFolder(), filename);
    }

    @Override
    public File getDownloadedFile(String fileName) {
        return new File(this.getDownloadFolder(), fileName);
    }

    protected String getAttributesLocationFromElement(WebElement element) {
        String attribute;
        String tagname = element.getTagName().toLowerCase();
        if (tagname.equals("input") || tagname.equals("a")) {
            attribute = "href";
        } else if (tagname.equals("img")) {
            attribute = "src";
        } else {
            LOGGER.error((Object)("Oops, this type cannot be handled by this method. The element was of type: " + element.getTagName()));
            return "";
        }
        return element.getAttribute(attribute);
    }
}

