/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.selenium.screenrecorder;

import java.awt.AWTException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.monte.screenrecorder.ScreenRecorder;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.selenium.screenrecorder.factory.DefaultScreenRecorderFactory;
import org.unitils.selenium.screenrecorder.factory.ScreenRecorderFactory;
import org.unitils.util.PropertyUtils;

public class ScreenRecordingModule
implements Module {
    private ScreenRecorder screenRecorder;
    private ScreenRecorderFactory screenRecorderFactory;
    protected static final String FACTORY_PATH = "org.unitils.selenium.screenrecorder.factory";
    private static final Log LOGGER = LogFactory.getLog(ScreenRecordingModule.class);

    public void init(Properties configuration) {
        this.screenRecorderFactory = (ScreenRecorderFactory)PropertyUtils.getInstance((String)FACTORY_PATH, (Object)new DefaultScreenRecorderFactory(), (Properties)configuration);
    }

    public void afterInit() {
    }

    protected void createScreenRecorder(Method testMethod) {
        try {
            this.screenRecorder = this.screenRecorderFactory.createScreenRecorder(testMethod);
        }
        catch (AWTException ex) {
            LOGGER.error((Object)"Could not create the screen recorder.", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Could not create the screen recorder.", (Throwable)ex);
        }
    }

    protected void startScreenRecorder() {
        try {
            if (this.screenRecorder != null) {
                this.screenRecorder.start();
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Could not start the screen recorder.", (Throwable)ex);
        }
    }

    protected void stopScreenRecorder() {
        try {
            if (this.screenRecorder != null) {
                this.screenRecorder.stop();
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Could not stop the screen recorder.", (Throwable)ex);
        }
    }

    protected void logCreatedFiles() {
        List createdMovieFiles = this.screenRecorder.getCreatedMovieFiles();
        for (File movie : createdMovieFiles) {
            LOGGER.info((Object)("Created screen recording: " + movie.getAbsolutePath()));
        }
    }

    public TestListener getTestListener() {
        return new ScreenRecordingTestlistener();
    }

    public class ScreenRecordingTestlistener
    extends TestListener {
        public void beforeTestSetUp(Object testObject, Method testMethod) {
            ScreenRecordingModule.this.createScreenRecorder(testMethod);
            ScreenRecordingModule.this.startScreenRecorder();
        }

        public void afterTestMethod(Object testObject, Method testMethod, Throwable testThrowable) {
            ScreenRecordingModule.this.stopScreenRecorder();
            ScreenRecordingModule.this.logCreatedFiles();
        }
    }
}

