/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.selenium.screenrecorder.factory;

import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.math.Rational;
import org.unitils.selenium.screenrecorder.factory.ScreenRecorderFactory;

public class DefaultScreenRecorderFactory
extends ScreenRecorderFactory {
    @Override
    protected GraphicsConfiguration createGraphicsConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    @Override
    protected Format createFileFormat() {
        return new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/avi"});
    }

    @Override
    protected Rectangle createCaptureArea() throws HeadlessException {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = screenSize.width;
        int height = screenSize.height;
        return new Rectangle(0, 0, width, height);
    }

    @Override
    protected Format createVideoFormat() {
        return new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "tscc", VideoFormatKeys.CompressorNameKey, "tscc", VideoFormatKeys.DepthKey, 24, FormatKeys.FrameRateKey, Rational.valueOf((double)15.0), VideoFormatKeys.QualityKey, Float.valueOf(1.0f), FormatKeys.KeyFrameIntervalKey, 900});
    }

    @Override
    protected Format createMouseFormat() {
        return new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "black", FormatKeys.FrameRateKey, Rational.valueOf((double)30.0)});
    }

    @Override
    protected Format createAudioFormat() {
        return null;
    }

    @Override
    protected File createExportFolder() {
        return new File("./target/screenRecordings/" + this.testMethod.getName());
    }
}

