package org.unitils.spring.batch.annotations;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;


/**
 *
 * Marker annotation specifies placeholder for the
 * {@link org.unitils.spring.batch.BatchTest} that should be reused used by
 * the tests.
 *
 * @author Jef Verelst
 * @author Jeroen Horemans
 * @author Thomas De Rycke
 * @author Willemijn Wouters
 * 
 * @since 1.0.0
 */
@Target(FIELD)
@Retention(RUNTIME)
@Inherited
public @interface BatchTestPlaceHolder {
    //empty
}
