package org.unitils.spring.batch;


/**
 * Enumerations for batch options.
 * 
 * @author Jef Verelst
 * @author Jeroen Horemans
 * @author Thomas De Rycke
 * @author Willemijn Wouters
 * @author Bruno Bouku
 * 
 * @since 1.0.0
 *
 */
public enum BatchOption {
    
    /** indication of no options. */
    NONE(""),
    /** option for restart. */
    RESTART("-restart"), 
    /** option for next. */
    NEXT("-next"), 
    /** option for abandon. */
    ABANDON("-abandon"), 
    /** option for stop. */
    STOP("-stop");
    
    private String value;
    
    BatchOption(String value) {
        this.value = value;
    }

    /**
     * @return {@link String}
     */
    public String value() {
        return value;
    }
}
