package org.unitils.spring.batch;

import org.springframework.batch.core.launch.support.SystemExiter;

/**
 * Class to prevent spring batch from terminating the JVM. It also allows
 * the test to recover the response code.
 *
 * @author Jef Verelst
 * @author Jeroen Horemans
 * @author Thomas De Rycke
 * @author Willemijn Wouters
 * 
 * @since 1.0.0
 */
public class SystemExitHelper implements SystemExiter {

    private int exitCode;
    
    @Override
    public void exit(int status) {
        this.exitCode = status;
    }

    /**
     * @return int
     */
    public int getExitCode() {
        return exitCode;
    }

}
