package org.unitils.spring.batch.annotations;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import org.unitils.spring.batch.BatchOption;

/**
 * Creates a {@link BatchTestEnvironment} .
 * 
 * When using this annotation on an object it shall only have effect when the object is of type
 * {@link BatchTestEnvironment}
 * 
 * @author Jef Verelst
 * @author Jeroen Horemans
 * @author Thomas De Rycke
 * @author Willemijn Wouters
 * 
 * @since 1.0.0
 * 
 */
@Target({
    METHOD, FIELD
})
@Retention(RUNTIME)
@Inherited
public @interface BatchTestEnvironment {

    /**
     * The Spring context in which the batch project is defined. When not filling it in we expect a application context form the {@link
     * SpringModule} to be present.
     * 
     * @return {@link String}
     */
    String contextFile() default "";

    /**
     * The job to be executed in the context file.
     * 
     * @return {@link String}
     */
    String job();

    /**
     * The expected exit code (defaults to 0). Tests will fail when the exit code does not match.
     * 
     * @return {@link Integer}
     */
    int exitCode() default 0;

    /**
     * The parameter to send with the job execution, allowing for testing multiple new executions of same job. If true it will send simply a
     * date to the batch execution. If true and the jobParameters are filled in then it will take those parameters.
     * 
     * @return {@link Boolean}
     */
    boolean parameter() default false;

    /**
     * The jobParameters to send to the job execution. If they are not empty they will be used.
     * 
     * @return {@link String}
     */
    String jobParameters() default "";

    /**
     * The option to send with the job execution, allowing for testing restart for instance, default it is set to none, meaning no options
     * will be sent to the job execution.
     * 
     * @return {@link BatchOption}
     */
    BatchOption option() default BatchOption.NONE;
}
