/*
 * Copyright 2012,  Unitils.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.unitils.testlink;

import java.net.URL;

import org.unitils.core.UnitilsException;

import br.eti.kinoshita.testlinkjavaapi.TestLinkAPI;

/**
 * Make sure that in the config.inc.php of your testlink the following settings are correct :
 * <pre>
 * $tlCfg->api->enabled = TRUE;
 * 
 * $tlCfg->exec_cfg->enable_test_automation = ENABLED;
 * </pre>
 * 
 * @author Jeroen Horemans
 * @author Thomas De Rycke
 * 
 * @since 3.3.1
 * 
 */
public class TestLinkConnectorFactory {

    protected static final String XML_RPC = "/lib/api/xmlrpc.php";

    private String devkey;

    public String url;

    public String projectName;

	private String username;

    public TestLinkConnectorFactory(String url, String devkey, String projectName, String username) {
        this.url = url;
        this.devkey = devkey;
        this.projectName = projectName;
        this.username = username;
    }


    public TestLinkConnector create(String testPlanId, Boolean overwrite, String buildName, Boolean createPlanIfNeeded, Boolean createTestIfNeeded, Boolean assignTestToPlan) {
        try {
            TestLinkAPI api = new TestLinkAPI(new URL(url + XML_RPC), devkey);
            return new TestLinkConnector(api, projectName, username, testPlanId, overwrite, buildName, createPlanIfNeeded, createTestIfNeeded, assignTestToPlan);
        } catch (Exception e) {
            throw new UnitilsException("failed to initialize connection with testlink", e);
        }

    }

}
