/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.testlink;

import br.eti.kinoshita.testlinkjavaapi.TestLinkAPI;
import br.eti.kinoshita.testlinkjavaapi.constants.ActionOnDuplicate;
import br.eti.kinoshita.testlinkjavaapi.constants.ExecutionStatus;
import br.eti.kinoshita.testlinkjavaapi.model.Build;
import br.eti.kinoshita.testlinkjavaapi.model.TestCase;
import br.eti.kinoshita.testlinkjavaapi.model.TestPlan;
import br.eti.kinoshita.testlinkjavaapi.model.TestProject;
import br.eti.kinoshita.testlinkjavaapi.model.TestSuite;
import br.eti.kinoshita.testlinkjavaapi.util.TestLinkAPIException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.unitils.core.UnitilsException;

public class TestLinkConnector {
    private static final Logger LOGGER = Logger.getLogger(TestLinkConnector.class);
    private TestLinkAPI api;
    private String testPlanName;
    private Boolean overwrite = true;
    private String buildName;
    private String projectName;
    private Boolean createPlanIfNeeded = false;
    private Boolean createTestIfNeeded = false;
    private Boolean assignTestToPlan = false;
    private String username;

    public TestLinkConnector(TestLinkAPI api, String projectName, String username, String testPlan, Boolean overwrite, String buildName) {
        this.api = api;
        this.projectName = projectName;
        this.username = username;
        this.testPlanName = testPlan;
        this.overwrite = overwrite;
        this.buildName = buildName;
    }

    public TestLinkConnector(TestLinkAPI api, String projectName, String username, String testPlanId, Boolean overwrite, String buildName, Boolean createPlanIfNeeded, Boolean createTestIfNeeded, Boolean assignTestToPlan) {
        this(api, projectName, username, testPlanId, overwrite, buildName);
        this.createPlanIfNeeded = createPlanIfNeeded;
        this.createTestIfNeeded = createTestIfNeeded;
        this.assignTestToPlan = assignTestToPlan;
    }

    public TestCase updateTestCase(String externalId, String suite, String msg, Throwable ex) {
        ExecutionStatus status = this.getStatus(ex);
        String notes = this.getNotes(ex);
        TestPlan testPlan = this.getTestPlan(this.testPlanName, this.projectName);
        Build build = this.getBuild(testPlan.getId(), this.buildName);
        TestCase testCase = this.getTestCase(externalId, suite);
        try {
            this.api.setTestCaseExecutionResult(testCase.getId(), null, testPlan.getId(), status, build.getId(), this.buildName, notes, Boolean.valueOf(true), "", null, "", new HashMap(), this.overwrite);
        }
        catch (TestLinkAPIException e) {
            if (this.createTestIfNeeded.booleanValue()) {
                this.addTestCaseToTestPlan(testCase, testPlan);
                this.api.setTestCaseExecutionResult(testCase.getId(), null, testPlan.getId(), status, build.getId(), this.buildName, notes, Boolean.valueOf(true), "", null, "", new HashMap(), this.overwrite);
            }
            throw e;
        }
        return testCase;
    }

    protected TestCase getTestCase(String externalId, String suite) {
        try {
            return this.api.getTestCaseByExternalId(externalId, null);
        }
        catch (TestLinkAPIException e) {
            TestSuite testSuite;
            block5: {
                testSuite = this.getTestSuite(suite, this.getCurrentProject().getId(), this.getTestPlan(this.testPlanName, this.projectName).getId());
                if (!externalId.startsWith(this.api.getTestProjectByName(this.projectName).getPrefix())) {
                    LOGGER.debug((Object)("externalID not found  " + externalId + "lets try by name"));
                    try {
                        Integer id = this.api.getTestCaseIDByName(externalId, testSuite.getName(), this.projectName, null);
                        return this.api.getTestCase(id, null, null);
                    }
                    catch (TestLinkAPIException e2) {
                        if (this.createTestIfNeeded.booleanValue()) break block5;
                        throw e2;
                    }
                }
            }
            LOGGER.info((Object)("case " + externalId + " not found, creating it now"));
            return this.createTestCase(externalId, testSuite.getId());
        }
    }

    protected TestCase createTestCase(String externalId, Integer suiteId) {
        if (!this.createTestIfNeeded.booleanValue()) {
            throw new UnitilsException("error in TestLink module, plz contact the quality assurance team");
        }
        TestProject project = this.getCurrentProject();
        TestCase result = this.api.createTestCase(externalId, suiteId, project.getId(), this.username, "To be fixed", new ArrayList(), "", null, null, null, null, Boolean.valueOf(true), ActionOnDuplicate.CREATE_NEW_VERSION);
        result.setVersion(Integer.valueOf(1));
        return result;
    }

    private TestProject getCurrentProject() {
        return this.api.getTestProjectByName(this.projectName);
    }

    protected TestSuite getTestSuite(String suiteName, Integer projectId, Integer testPlanId) {
        String[] suiteNames = suiteName.split("/");
        ArrayList<TestSuite> suites = new ArrayList<TestSuite>(Arrays.asList(this.api.getTestSuitesForTestPlan(testPlanId)));
        int index = 0;
        TestSuite testSuite = null;
        for (int i = 0; i < suiteNames.length; ++i) {
            String suite = suiteNames[i];
            testSuite = index == 0 ? this.createOrGetTestSuite(suite, projectId, suites, null) : this.createOrGetTestSuite(suite, projectId, suites, testSuite.getId());
            ++index;
        }
        return testSuite;
    }

    private TestSuite createOrGetTestSuite(String suiteName, Integer projectId, List<TestSuite> suites, Integer parentId) {
        if (suiteName.isEmpty()) {
            return suites.get(0);
        }
        for (TestSuite testSuite : suites) {
            if (!testSuite.getName().equals(suiteName) || !testSuite.getParentId().equals(parentId) && parentId != null) continue;
            return testSuite;
        }
        TestSuite suite = this.api.createTestSuite(projectId, suiteName, "", parentId, Integer.valueOf(1), Boolean.valueOf(true), ActionOnDuplicate.CREATE_NEW_VERSION);
        suites.add(suite);
        return suite;
    }

    protected void addTestCaseToTestPlan(TestCase testCase, TestPlan testPlan) {
        if (this.assignTestToPlan.booleanValue()) {
            TestProject project = this.getCurrentProject();
            this.api.addTestCaseToTestPlan(project.getId(), testPlan.getId(), testCase.getId(), testCase.getVersion(), null, null, null);
        }
    }

    protected TestPlan getTestPlan(String testPlanName2, String projectName1) {
        try {
            return this.api.getTestPlanByName(this.testPlanName, projectName1);
        }
        catch (TestLinkAPIException e) {
            if (!this.createPlanIfNeeded.booleanValue()) {
                throw e;
            }
            return this.api.createTestPlan(testPlanName2, projectName1, null, Boolean.valueOf(true), Boolean.valueOf(true));
        }
    }

    protected Build getBuild(Integer testPlanId, String buildName1) {
        Build[] builds = this.api.getBuildsForTestPlan(testPlanId);
        if (builds != null) {
            for (Build build : builds) {
                if (!buildName1.equalsIgnoreCase(build.getName())) continue;
                return build;
            }
        }
        return this.api.createBuild(testPlanId, buildName1, "");
    }

    protected String getNotes(Throwable ex) {
        if (ex != null) {
            return ex.getMessage();
        }
        return "ok";
    }

    protected ExecutionStatus getStatus(Throwable ex) {
        if (ex != null) {
            return ExecutionStatus.FAILED;
        }
        return ExecutionStatus.PASSED;
    }
}

