/*
 * Copyright 2012,  Unitils.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.unitils.testlink;

import java.lang.reflect.Method;
import java.util.Properties;

import org.apache.log4j.Logger;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.testlink.annotation.TestLink;
import org.unitils.util.PropertyUtils;


/**
 * 
 * @author Jeroen Horemans
 * @author Thomas De Rycke
 * 
 * @since 3.3.1
 * 
 */
public class TestLinkModule implements Module {

    private TestLinkConnector connector;
    
    private String packageName = "org.unitils.testlink";

    private static final Logger LOGGER = Logger.getLogger(TestLinkModule.class);

    @Override
    public void init(Properties properties) {
        String url = PropertyUtils.getString(packageName + ".url", properties);
        String devkey = PropertyUtils.getString(packageName + ".devkey", properties);
        String username = PropertyUtils.getString(packageName + ".username", properties);
        String projectName = PropertyUtils.getString(packageName + ".project", properties);
        String testPlanId = PropertyUtils.getString(packageName + ".testPlan", properties);
        String buildName = PropertyUtils.getString(packageName + ".buildName", properties);
        Boolean overwrite = PropertyUtils.getBoolean(packageName + ".overwrite", true, properties);

        Boolean createTestIfNeeded = PropertyUtils.getBoolean(packageName + ".createTestIfNeeded", false, properties);
        Boolean createPlanIfNeeded = PropertyUtils.getBoolean(packageName + ".createTestPlanIfNeeded", false, properties);
        Boolean assignTestToPlan = PropertyUtils.getBoolean(packageName + ".assingTestIfNeeded", false, properties);


        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Connection to testlink will be made with url " + url + " ; devkey " + devkey + " ; projectName " + projectName + " ; testPlan " + testPlanId);
        }
        TestLinkConnectorFactory factory = new TestLinkConnectorFactory(url, devkey, projectName,username);

        connector = factory.create(testPlanId, overwrite, buildName, createPlanIfNeeded, createTestIfNeeded, assignTestToPlan);
    }

    @Override
    public void afterInit() {
        //do nothing
    }

    public void updateTestCase(String externalId, String suite, Throwable ex) {
        LOGGER.debug("updating " + externalId);
        connector.updateTestCase(externalId, suite, "Automated test", ex);
    }

    @Override
    public TestListener getTestListener() {
        return new TestLinkListener();
    }

    protected class TestLinkListener extends TestListener {

        @Override
        public void afterTestMethod(Object testObject, Method testMethod, Throwable testThrowable) {
            TestLink annotation = testMethod.getAnnotation(TestLink.class);
            if(annotation != null){
            	updateTestCase(annotation.value(), annotation.suite(), testThrowable);
            }
        }
    }

}
