/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.testlink;

import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.unitils.core.Module;
import org.unitils.core.TestListener;
import org.unitils.testlink.TestLinkConnector;
import org.unitils.testlink.TestLinkConnectorFactory;
import org.unitils.testlink.annotation.TestLink;
import org.unitils.util.PropertyUtils;

public class TestLinkModule
implements Module {
    private TestLinkConnector connector;
    private String packageName = "org.unitils.testlink";
    private static final Logger LOGGER = Logger.getLogger(TestLinkModule.class);

    public void init(Properties properties) {
        String url = PropertyUtils.getString((String)(this.packageName + ".url"), (Properties)properties);
        String devkey = PropertyUtils.getString((String)(this.packageName + ".devkey"), (Properties)properties);
        String username = PropertyUtils.getString((String)(this.packageName + ".username"), (Properties)properties);
        String projectName = PropertyUtils.getString((String)(this.packageName + ".project"), (Properties)properties);
        String testPlanId = PropertyUtils.getString((String)(this.packageName + ".testPlan"), (Properties)properties);
        String buildName = PropertyUtils.getString((String)(this.packageName + ".buildName"), (Properties)properties);
        Boolean overwrite = PropertyUtils.getBoolean((String)(this.packageName + ".overwrite"), (boolean)true, (Properties)properties);
        Boolean createTestIfNeeded = PropertyUtils.getBoolean((String)(this.packageName + ".createTestIfNeeded"), (boolean)false, (Properties)properties);
        Boolean createPlanIfNeeded = PropertyUtils.getBoolean((String)(this.packageName + ".createTestPlanIfNeeded"), (boolean)false, (Properties)properties);
        Boolean assignTestToPlan = PropertyUtils.getBoolean((String)(this.packageName + ".assingTestIfNeeded"), (boolean)false, (Properties)properties);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Connection to testlink will be made with url " + url + " ; devkey " + devkey + " ; projectName " + projectName + " ; testPlan " + testPlanId));
        }
        TestLinkConnectorFactory factory = new TestLinkConnectorFactory(url, devkey, projectName, username);
        this.connector = factory.create(testPlanId, overwrite, buildName, createPlanIfNeeded, createTestIfNeeded, assignTestToPlan);
    }

    public void afterInit() {
    }

    public void updateTestCase(String externalId, String suite, Throwable ex) {
        LOGGER.debug((Object)("updating " + externalId));
        this.connector.updateTestCase(externalId, suite, "Automated test", ex);
    }

    public TestListener getTestListener() {
        return new TestLinkListener();
    }

    protected class TestLinkListener
    extends TestListener {
        protected TestLinkListener() {
        }

        public void afterTestMethod(Object testObject, Method testMethod, Throwable testThrowable) {
            TestLink annotation = testMethod.getAnnotation(TestLink.class);
            if (annotation != null) {
                TestLinkModule.this.updateTestCase(annotation.value(), annotation.suite(), testThrowable);
            }
        }
    }
}

