/*
 * Copyright 2012,  Unitils.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.unitils.testlink;

import java.net.URL;

import org.unitils.core.UnitilsException;

import br.eti.kinoshita.testlinkjavaapi.TestLinkAPI;
import java.util.LinkedList;
import java.util.List;

/**
 * Make sure that in the config.inc.php of your testlink the following settings are correct :
 * <pre>
 * $tlCfg->api->enabled = TRUE;
 * 
 * $tlCfg->exec_cfg->enable_test_automation = ENABLED;
 * </pre>
 * 
 * @author Jeroen Horemans
 * @author Thomas De Rycke
 * @author Jef Verelst
 * 
 * @since 3.3.1
 * 
 */
public class TestLinkConnectorFactory {
    
    /**
     * The location of the XML-RPC interface in versions from 1.9.7 onwards.
     * In version 1.9.5, we used "/lib/api/xmlrpc.php", but apparently this 
     * no longer works. This location however, also works in 1.9.5
     */
    protected static final String XML_RPC = "/lib/api/xmlrpc/v1/xmlrpc.php";

    private String devkey;

    public String url;

    public String projectName;

    private String username;
    
    private List<String> possibleXmlRpcLocations;

    public TestLinkConnectorFactory(String url, String devkey, String projectName, String username, String xmlRpc) {
        this.url = url;
        this.devkey = devkey;
        this.projectName = projectName;
        this.username = username;
        this.possibleXmlRpcLocations = new LinkedList<String>();
        if(xmlRpc != null) {
            // if specified, add as first candidate
            this.possibleXmlRpcLocations.add(xmlRpc);
        }
        this.possibleXmlRpcLocations.add(XML_RPC);        
    }


    public TestLinkConnector create(String testPlanId, Boolean overwrite, String buildName, Boolean createPlanIfNeeded, Boolean createTestIfNeeded, Boolean assignTestToPlan) {
        for(String xmlRpcLocation : this.possibleXmlRpcLocations) {
            try {
                TestLinkAPI api = new TestLinkAPI(new URL(url + xmlRpcLocation), devkey);
                return new TestLinkConnector(api, projectName, username, testPlanId, overwrite, buildName, createPlanIfNeeded, createTestIfNeeded, assignTestToPlan);
            } catch (Exception e) {
                // continue with the other candidates
            }
        }
        throw new UnitilsException("failed to initialize connection with testlink");
    }

}
