/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.testlink;

import br.eti.kinoshita.testlinkjavaapi.TestLinkAPI;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.unitils.core.UnitilsException;
import org.unitils.testlink.TestLinkConnector;

public class TestLinkConnectorFactory {
    protected static final String XML_RPC = "/lib/api/xmlrpc/v1/xmlrpc.php";
    private String devkey;
    public String url;
    public String projectName;
    private String username;
    private List<String> possibleXmlRpcLocations;

    public TestLinkConnectorFactory(String url, String devkey, String projectName, String username, String xmlRpc) {
        this.url = url;
        this.devkey = devkey;
        this.projectName = projectName;
        this.username = username;
        this.possibleXmlRpcLocations = new LinkedList<String>();
        if (xmlRpc != null) {
            this.possibleXmlRpcLocations.add(xmlRpc);
        }
        this.possibleXmlRpcLocations.add(XML_RPC);
    }

    public TestLinkConnector create(String testPlanId, Boolean overwrite, String buildName, Boolean createPlanIfNeeded, Boolean createTestIfNeeded, Boolean assignTestToPlan) {
        for (String xmlRpcLocation : this.possibleXmlRpcLocations) {
            try {
                TestLinkAPI api = new TestLinkAPI(new URL(this.url + xmlRpcLocation), this.devkey);
                return new TestLinkConnector(api, this.projectName, this.username, testPlanId, overwrite, buildName, createPlanIfNeeded, createTestIfNeeded, assignTestToPlan);
            }
            catch (Exception e) {
            }
        }
        throw new UnitilsException("failed to initialize connection with testlink");
    }
}

